package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMediaResourcePackage invokes the retailadvqa_public.QueryMediaResourcePackage API synchronously
func (client *Client) QueryMediaResourcePackage(request *QueryMediaResourcePackageRequest) (response *QueryMediaResourcePackageResponse, err error) {
	response = CreateQueryMediaResourcePackageResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMediaResourcePackageWithChan invokes the retailadvqa_public.QueryMediaResourcePackage API asynchronously
func (client *Client) QueryMediaResourcePackageWithChan(request *QueryMediaResourcePackageRequest) (<-chan *QueryMediaResourcePackageResponse, <-chan error) {
	responseChan := make(chan *QueryMediaResourcePackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMediaResourcePackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMediaResourcePackageWithCallback invokes the retailadvqa_public.QueryMediaResourcePackage API asynchronously
func (client *Client) QueryMediaResourcePackageWithCallback(request *QueryMediaResourcePackageRequest, callback func(response *QueryMediaResourcePackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMediaResourcePackageResponse
		var err error
		defer close(result)
		response, err = client.QueryMediaResourcePackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMediaResourcePackageRequest is the request struct for api QueryMediaResourcePackage
type QueryMediaResourcePackageRequest struct {
	*requests.RpcRequest
	AccessId     string           `position:"Query" name:"AccessId"`
	Template     string           `position:"Query" name:"Template"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	Status       string           `position:"Query" name:"Status"`
}

// QueryMediaResourcePackageResponse is the response struct for api QueryMediaResourcePackage
type QueryMediaResourcePackageResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	ErrorCode string                          `json:"ErrorCode" xml:"ErrorCode"`
	Success   string                          `json:"Success" xml:"Success"`
	Data      DataInQueryMediaResourcePackage `json:"Data" xml:"Data"`
}

// CreateQueryMediaResourcePackageRequest creates a request to invoke QueryMediaResourcePackage API
func CreateQueryMediaResourcePackageRequest() (request *QueryMediaResourcePackageRequest) {
	request = &QueryMediaResourcePackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "QueryMediaResourcePackage", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryMediaResourcePackageResponse creates a response to parse from QueryMediaResourcePackage response
func CreateQueryMediaResourcePackageResponse() (response *QueryMediaResourcePackageResponse) {
	response = &QueryMediaResourcePackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
