package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSharedResources invokes the resourcesharing.ListSharedResources API synchronously
func (client *Client) ListSharedResources(request *ListSharedResourcesRequest) (response *ListSharedResourcesResponse, err error) {
	response = CreateListSharedResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSharedResourcesWithChan invokes the resourcesharing.ListSharedResources API asynchronously
func (client *Client) ListSharedResourcesWithChan(request *ListSharedResourcesRequest) (<-chan *ListSharedResourcesResponse, <-chan error) {
	responseChan := make(chan *ListSharedResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSharedResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSharedResourcesWithCallback invokes the resourcesharing.ListSharedResources API asynchronously
func (client *Client) ListSharedResourcesWithCallback(request *ListSharedResourcesRequest, callback func(response *ListSharedResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSharedResourcesResponse
		var err error
		defer close(result)
		response, err = client.ListSharedResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSharedResourcesRequest is the request struct for api ListSharedResources
type ListSharedResourcesRequest struct {
	*requests.RpcRequest
	NextToken        string           `position:"Query" name:"NextToken"`
	ResourceShareIds *[]string        `position:"Query" name:"ResourceShareIds"  type:"Repeated"`
	ResourceOwner    string           `position:"Query" name:"ResourceOwner"`
	ResourceType     string           `position:"Query" name:"ResourceType"`
	Target           string           `position:"Query" name:"Target"`
	MaxResults       requests.Integer `position:"Query" name:"MaxResults"`
	ResourceIds      *[]string        `position:"Query" name:"ResourceIds"  type:"Repeated"`
}

// ListSharedResourcesResponse is the response struct for api ListSharedResources
type ListSharedResourcesResponse struct {
	*responses.BaseResponse
	NextToken       string           `json:"NextToken" xml:"NextToken"`
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	SharedResources []SharedResource `json:"SharedResources" xml:"SharedResources"`
}

// CreateListSharedResourcesRequest creates a request to invoke ListSharedResources API
func CreateListSharedResourcesRequest() (request *ListSharedResourcesRequest) {
	request = &ListSharedResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "ListSharedResources", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSharedResourcesResponse creates a response to parse from ListSharedResources response
func CreateListSharedResourcesResponse() (response *ListSharedResourcesResponse) {
	response = &ListSharedResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
