package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRuleV4 invokes the qualitycheck.UpdateRuleV4 API synchronously
func (client *Client) UpdateRuleV4(request *UpdateRuleV4Request) (response *UpdateRuleV4Response, err error) {
	response = CreateUpdateRuleV4Response()
	err = client.DoAction(request, response)
	return
}

// UpdateRuleV4WithChan invokes the qualitycheck.UpdateRuleV4 API asynchronously
func (client *Client) UpdateRuleV4WithChan(request *UpdateRuleV4Request) (<-chan *UpdateRuleV4Response, <-chan error) {
	responseChan := make(chan *UpdateRuleV4Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRuleV4(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRuleV4WithCallback invokes the qualitycheck.UpdateRuleV4 API asynchronously
func (client *Client) UpdateRuleV4WithCallback(request *UpdateRuleV4Request, callback func(response *UpdateRuleV4Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRuleV4Response
		var err error
		defer close(result)
		response, err = client.UpdateRuleV4(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRuleV4Request is the request struct for api UpdateRuleV4
type UpdateRuleV4Request struct {
	*requests.RpcRequest
	IsSchemeData         requests.Integer `position:"Body" name:"IsSchemeData"`
	ReturnRelatedSchemes requests.Boolean `position:"Body" name:"ReturnRelatedSchemes"`
	IsCopy               requests.Boolean `position:"Body" name:"IsCopy"`
	JsonStrForRule       string           `position:"Body" name:"JsonStrForRule"`
	RuleId               requests.Integer `position:"Body" name:"RuleId"`
	BaseMeAgentId        requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// UpdateRuleV4Response is the response struct for api UpdateRuleV4
type UpdateRuleV4Response struct {
	*responses.BaseResponse
	RequestId      string                 `json:"RequestId" xml:"RequestId"`
	Success        bool                   `json:"Success" xml:"Success"`
	Code           string                 `json:"Code" xml:"Code"`
	Message        string                 `json:"Message" xml:"Message"`
	HttpStatusCode int                    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           int64                  `json:"Data" xml:"Data"`
	Messages       MessagesInUpdateRuleV4 `json:"Messages" xml:"Messages"`
}

// CreateUpdateRuleV4Request creates a request to invoke UpdateRuleV4 API
func CreateUpdateRuleV4Request() (request *UpdateRuleV4Request) {
	request = &UpdateRuleV4Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateRuleV4", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateRuleV4Response creates a response to parse from UpdateRuleV4 response
func CreateUpdateRuleV4Response() (response *UpdateRuleV4Response) {
	response = &UpdateRuleV4Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
