package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClusterWarning invokes the qianzhou.GetClusterWarning API synchronously
func (client *Client) GetClusterWarning(request *GetClusterWarningRequest) (response *GetClusterWarningResponse, err error) {
	response = CreateGetClusterWarningResponse()
	err = client.DoAction(request, response)
	return
}

// GetClusterWarningWithChan invokes the qianzhou.GetClusterWarning API asynchronously
func (client *Client) GetClusterWarningWithChan(request *GetClusterWarningRequest) (<-chan *GetClusterWarningResponse, <-chan error) {
	responseChan := make(chan *GetClusterWarningResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClusterWarning(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClusterWarningWithCallback invokes the qianzhou.GetClusterWarning API asynchronously
func (client *Client) GetClusterWarningWithCallback(request *GetClusterWarningRequest, callback func(response *GetClusterWarningResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClusterWarningResponse
		var err error
		defer close(result)
		response, err = client.GetClusterWarning(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClusterWarningRequest is the request struct for api GetClusterWarning
type GetClusterWarningRequest struct {
	*requests.RoaRequest
	ClusterID string `position:"Query" name:"clusterID"`
}

// GetClusterWarningResponse is the response struct for api GetClusterWarning
type GetClusterWarningResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateGetClusterWarningRequest creates a request to invoke GetClusterWarning API
func CreateGetClusterWarningRequest() (request *GetClusterWarningRequest) {
	request = &GetClusterWarningRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "GetClusterWarning", "/popapi/getKeyClusterWarningList", "", "")
	request.Method = requests.GET
	return
}

// CreateGetClusterWarningResponse creates a response to parse from GetClusterWarning response
func CreateGetClusterWarningResponse() (response *GetClusterWarningResponse) {
	response = &GetClusterWarningResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
