package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeActiveOperationMaintainConf invokes the polardbx.DescribeActiveOperationMaintainConf API synchronously
func (client *Client) DescribeActiveOperationMaintainConf(request *DescribeActiveOperationMaintainConfRequest) (response *DescribeActiveOperationMaintainConfResponse, err error) {
	response = CreateDescribeActiveOperationMaintainConfResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeActiveOperationMaintainConfWithChan invokes the polardbx.DescribeActiveOperationMaintainConf API asynchronously
func (client *Client) DescribeActiveOperationMaintainConfWithChan(request *DescribeActiveOperationMaintainConfRequest) (<-chan *DescribeActiveOperationMaintainConfResponse, <-chan error) {
	responseChan := make(chan *DescribeActiveOperationMaintainConfResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeActiveOperationMaintainConf(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeActiveOperationMaintainConfWithCallback invokes the polardbx.DescribeActiveOperationMaintainConf API asynchronously
func (client *Client) DescribeActiveOperationMaintainConfWithCallback(request *DescribeActiveOperationMaintainConfRequest, callback func(response *DescribeActiveOperationMaintainConfResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeActiveOperationMaintainConfResponse
		var err error
		defer close(result)
		response, err = client.DescribeActiveOperationMaintainConf(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeActiveOperationMaintainConfRequest is the request struct for api DescribeActiveOperationMaintainConf
type DescribeActiveOperationMaintainConfRequest struct {
	*requests.RpcRequest
}

// DescribeActiveOperationMaintainConfResponse is the response struct for api DescribeActiveOperationMaintainConf
type DescribeActiveOperationMaintainConfResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HasConfig int64  `json:"HasConfig" xml:"HasConfig"`
	Config    Config `json:"Config" xml:"Config"`
}

// CreateDescribeActiveOperationMaintainConfRequest creates a request to invoke DescribeActiveOperationMaintainConf API
func CreateDescribeActiveOperationMaintainConfRequest() (request *DescribeActiveOperationMaintainConfRequest) {
	request = &DescribeActiveOperationMaintainConfRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeActiveOperationMaintainConf", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeActiveOperationMaintainConfResponse creates a response to parse from DescribeActiveOperationMaintainConf response
func CreateDescribeActiveOperationMaintainConfResponse() (response *DescribeActiveOperationMaintainConfResponse) {
	response = &DescribeActiveOperationMaintainConfResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
