package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSampleConsistencyJob invokes the pairecservice.DeleteSampleConsistencyJob API synchronously
func (client *Client) DeleteSampleConsistencyJob(request *DeleteSampleConsistencyJobRequest) (response *DeleteSampleConsistencyJobResponse, err error) {
	response = CreateDeleteSampleConsistencyJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSampleConsistencyJobWithChan invokes the pairecservice.DeleteSampleConsistencyJob API asynchronously
func (client *Client) DeleteSampleConsistencyJobWithChan(request *DeleteSampleConsistencyJobRequest) (<-chan *DeleteSampleConsistencyJobResponse, <-chan error) {
	responseChan := make(chan *DeleteSampleConsistencyJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSampleConsistencyJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSampleConsistencyJobWithCallback invokes the pairecservice.DeleteSampleConsistencyJob API asynchronously
func (client *Client) DeleteSampleConsistencyJobWithCallback(request *DeleteSampleConsistencyJobRequest, callback func(response *DeleteSampleConsistencyJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSampleConsistencyJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteSampleConsistencyJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSampleConsistencyJobRequest is the request struct for api DeleteSampleConsistencyJob
type DeleteSampleConsistencyJobRequest struct {
	*requests.RoaRequest
	SampleConsistencyJobId string `position:"Path" name:"SampleConsistencyJobId"`
	InstanceId             string `position:"Query" name:"InstanceId"`
}

// DeleteSampleConsistencyJobResponse is the response struct for api DeleteSampleConsistencyJob
type DeleteSampleConsistencyJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSampleConsistencyJobRequest creates a request to invoke DeleteSampleConsistencyJob API
func CreateDeleteSampleConsistencyJobRequest() (request *DeleteSampleConsistencyJobRequest) {
	request = &DeleteSampleConsistencyJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DeleteSampleConsistencyJob", "/api/v1/sampleconsistencyjobs/[SampleConsistencyJobId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteSampleConsistencyJobResponse creates a response to parse from DeleteSampleConsistencyJob response
func CreateDeleteSampleConsistencyJobResponse() (response *DeleteSampleConsistencyJobResponse) {
	response = &DeleteSampleConsistencyJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
