package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckTrafficControlTaskExpression invokes the pairecservice.CheckTrafficControlTaskExpression API synchronously
func (client *Client) CheckTrafficControlTaskExpression(request *CheckTrafficControlTaskExpressionRequest) (response *CheckTrafficControlTaskExpressionResponse, err error) {
	response = CreateCheckTrafficControlTaskExpressionResponse()
	err = client.DoAction(request, response)
	return
}

// CheckTrafficControlTaskExpressionWithChan invokes the pairecservice.CheckTrafficControlTaskExpression API asynchronously
func (client *Client) CheckTrafficControlTaskExpressionWithChan(request *CheckTrafficControlTaskExpressionRequest) (<-chan *CheckTrafficControlTaskExpressionResponse, <-chan error) {
	responseChan := make(chan *CheckTrafficControlTaskExpressionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckTrafficControlTaskExpression(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckTrafficControlTaskExpressionWithCallback invokes the pairecservice.CheckTrafficControlTaskExpression API asynchronously
func (client *Client) CheckTrafficControlTaskExpressionWithCallback(request *CheckTrafficControlTaskExpressionRequest, callback func(response *CheckTrafficControlTaskExpressionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckTrafficControlTaskExpressionResponse
		var err error
		defer close(result)
		response, err = client.CheckTrafficControlTaskExpression(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckTrafficControlTaskExpressionRequest is the request struct for api CheckTrafficControlTaskExpression
type CheckTrafficControlTaskExpressionRequest struct {
	*requests.RoaRequest
	Expression  string `position:"Query" name:"Expression"`
	TableMetaId string `position:"Query" name:"TableMetaId"`
	InstanceId  string `position:"Query" name:"InstanceId"`
}

// CheckTrafficControlTaskExpressionResponse is the response struct for api CheckTrafficControlTaskExpression
type CheckTrafficControlTaskExpressionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	IsValie   bool   `json:"IsValie" xml:"IsValie"`
	Reason    string `json:"Reason" xml:"Reason"`
}

// CreateCheckTrafficControlTaskExpressionRequest creates a request to invoke CheckTrafficControlTaskExpression API
func CreateCheckTrafficControlTaskExpressionRequest() (request *CheckTrafficControlTaskExpressionRequest) {
	request = &CheckTrafficControlTaskExpressionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CheckTrafficControlTaskExpression", "/api/v1/trafficcontroltasks/action/checkexpression", "", "")
	request.Method = requests.GET
	return
}

// CreateCheckTrafficControlTaskExpressionResponse creates a response to parse from CheckTrafficControlTaskExpression response
func CreateCheckTrafficControlTaskExpressionResponse() (response *CheckTrafficControlTaskExpressionResponse) {
	response = &CheckTrafficControlTaskExpressionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
