package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateFunctionInstance invokes the opensearch.UpdateFunctionInstance API synchronously
func (client *Client) UpdateFunctionInstance(request *UpdateFunctionInstanceRequest) (response *UpdateFunctionInstanceResponse, err error) {
	response = CreateUpdateFunctionInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateFunctionInstanceWithChan invokes the opensearch.UpdateFunctionInstance API asynchronously
func (client *Client) UpdateFunctionInstanceWithChan(request *UpdateFunctionInstanceRequest) (<-chan *UpdateFunctionInstanceResponse, <-chan error) {
	responseChan := make(chan *UpdateFunctionInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateFunctionInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateFunctionInstanceWithCallback invokes the opensearch.UpdateFunctionInstance API asynchronously
func (client *Client) UpdateFunctionInstanceWithCallback(request *UpdateFunctionInstanceRequest, callback func(response *UpdateFunctionInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateFunctionInstanceResponse
		var err error
		defer close(result)
		response, err = client.UpdateFunctionInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateFunctionInstanceRequest is the request struct for api UpdateFunctionInstance
type UpdateFunctionInstanceRequest struct {
	*requests.RoaRequest
	InstanceName     string `position:"Path" name:"instanceName"`
	FunctionName     string `position:"Path" name:"functionName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// UpdateFunctionInstanceResponse is the response struct for api UpdateFunctionInstance
type UpdateFunctionInstanceResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	HttpCode  int64  `json:"HttpCode" xml:"HttpCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Latency   int64  `json:"Latency" xml:"Latency"`
}

// CreateUpdateFunctionInstanceRequest creates a request to invoke UpdateFunctionInstance API
func CreateUpdateFunctionInstanceRequest() (request *UpdateFunctionInstanceRequest) {
	request = &UpdateFunctionInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "UpdateFunctionInstance", "/v4/openapi/app-groups/[appGroupIdentity]/functions/[functionName]/instances/[instanceName]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateFunctionInstanceResponse creates a response to parse from UpdateFunctionInstance response
func CreateUpdateFunctionInstanceResponse() (response *UpdateFunctionInstanceResponse) {
	response = &UpdateFunctionInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
