package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListABTestExperiments invokes the opensearch.ListABTestExperiments API synchronously
func (client *Client) ListABTestExperiments(request *ListABTestExperimentsRequest) (response *ListABTestExperimentsResponse, err error) {
	response = CreateListABTestExperimentsResponse()
	err = client.DoAction(request, response)
	return
}

// ListABTestExperimentsWithChan invokes the opensearch.ListABTestExperiments API asynchronously
func (client *Client) ListABTestExperimentsWithChan(request *ListABTestExperimentsRequest) (<-chan *ListABTestExperimentsResponse, <-chan error) {
	responseChan := make(chan *ListABTestExperimentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListABTestExperiments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListABTestExperimentsWithCallback invokes the opensearch.ListABTestExperiments API asynchronously
func (client *Client) ListABTestExperimentsWithCallback(request *ListABTestExperimentsRequest, callback func(response *ListABTestExperimentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListABTestExperimentsResponse
		var err error
		defer close(result)
		response, err = client.ListABTestExperiments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListABTestExperimentsRequest is the request struct for api ListABTestExperiments
type ListABTestExperimentsRequest struct {
	*requests.RoaRequest
	GroupId          requests.Integer `position:"Path" name:"groupId"`
	SceneId          requests.Integer `position:"Path" name:"sceneId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// ListABTestExperimentsResponse is the response struct for api ListABTestExperiments
type ListABTestExperimentsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"requestId" xml:"requestId"`
	Result    []ResultItem `json:"result" xml:"result"`
}

// CreateListABTestExperimentsRequest creates a request to invoke ListABTestExperiments API
func CreateListABTestExperimentsRequest() (request *ListABTestExperimentsRequest) {
	request = &ListABTestExperimentsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListABTestExperiments", "/v4/openapi/app-groups/[appGroupIdentity]/scenes/[sceneId]/groups/[groupId]/experiments", "", "")
	request.Method = requests.GET
	return
}

// CreateListABTestExperimentsResponse creates a response to parse from ListABTestExperiments response
func CreateListABTestExperimentsResponse() (response *ListABTestExperimentsResponse) {
	response = &ListABTestExperimentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
