package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetReadyFlag invokes the oms.GetReadyFlag API synchronously
func (client *Client) GetReadyFlag(request *GetReadyFlagRequest) (response *GetReadyFlagResponse, err error) {
	response = CreateGetReadyFlagResponse()
	err = client.DoAction(request, response)
	return
}

// GetReadyFlagWithChan invokes the oms.GetReadyFlag API asynchronously
func (client *Client) GetReadyFlagWithChan(request *GetReadyFlagRequest) (<-chan *GetReadyFlagResponse, <-chan error) {
	responseChan := make(chan *GetReadyFlagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetReadyFlag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetReadyFlagWithCallback invokes the oms.GetReadyFlag API asynchronously
func (client *Client) GetReadyFlagWithCallback(request *GetReadyFlagRequest, callback func(response *GetReadyFlagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetReadyFlagResponse
		var err error
		defer close(result)
		response, err = client.GetReadyFlag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetReadyFlagRequest is the request struct for api GetReadyFlag
type GetReadyFlagRequest struct {
	*requests.RpcRequest
	Filter         string           `position:"Query" name:"Filter"`
	DomainCode     string           `position:"Query" name:"DomainCode"`
	DataType       string           `position:"Query" name:"DataType"`
	NextToken      string           `position:"Query" name:"NextToken"`
	CompressEnable requests.Boolean `position:"Query" name:"CompressEnable"`
	ApiType        string           `position:"Query" name:"ApiType"`
	MaxResult      requests.Integer `position:"Query" name:"MaxResult"`
}

// GetReadyFlagResponse is the response struct for api GetReadyFlag
type GetReadyFlagResponse struct {
	*responses.BaseResponse
	DataType   string `json:"DataType" xml:"DataType"`
	NextToken  string `json:"NextToken" xml:"NextToken"`
	Data       string `json:"Data" xml:"Data"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainCode string `json:"DomainCode" xml:"DomainCode"`
	ApiType    string `json:"ApiType" xml:"ApiType"`
	Compressed bool   `json:"Compressed" xml:"Compressed"`
}

// CreateGetReadyFlagRequest creates a request to invoke GetReadyFlag API
func CreateGetReadyFlagRequest() (request *GetReadyFlagRequest) {
	request = &GetReadyFlagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "GetReadyFlag", "", "")
	request.Method = requests.GET
	return
}

// CreateGetReadyFlagResponse creates a response to parse from GetReadyFlag response
func CreateGetReadyFlagResponse() (response *GetReadyFlagResponse) {
	response = &GetReadyFlagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
