package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSQLTuningAdvices invokes the oceanbasepro.DescribeSQLTuningAdvices API synchronously
func (client *Client) DescribeSQLTuningAdvices(request *DescribeSQLTuningAdvicesRequest) (response *DescribeSQLTuningAdvicesResponse, err error) {
	response = CreateDescribeSQLTuningAdvicesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSQLTuningAdvicesWithChan invokes the oceanbasepro.DescribeSQLTuningAdvices API asynchronously
func (client *Client) DescribeSQLTuningAdvicesWithChan(request *DescribeSQLTuningAdvicesRequest) (<-chan *DescribeSQLTuningAdvicesResponse, <-chan error) {
	responseChan := make(chan *DescribeSQLTuningAdvicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSQLTuningAdvices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSQLTuningAdvicesWithCallback invokes the oceanbasepro.DescribeSQLTuningAdvices API asynchronously
func (client *Client) DescribeSQLTuningAdvicesWithCallback(request *DescribeSQLTuningAdvicesRequest, callback func(response *DescribeSQLTuningAdvicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSQLTuningAdvicesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSQLTuningAdvices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSQLTuningAdvicesRequest is the request struct for api DescribeSQLTuningAdvices
type DescribeSQLTuningAdvicesRequest struct {
	*requests.RpcRequest
	StartTime      string `position:"Body" name:"StartTime"`
	TenantId       string `position:"Body" name:"TenantId"`
	SqlId          string `position:"Body" name:"SqlId"`
	EndTime        string `position:"Body" name:"EndTime"`
	InstanceId     string `position:"Body" name:"InstanceId"`
	DbName         string `position:"Body" name:"DbName"`
	AcceptLanguage string `position:"Body" name:"AcceptLanguage"`
}

// DescribeSQLTuningAdvicesResponse is the response struct for api DescribeSQLTuningAdvices
type DescribeSQLTuningAdvicesResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeSQLTuningAdvicesRequest creates a request to invoke DescribeSQLTuningAdvices API
func CreateDescribeSQLTuningAdvicesRequest() (request *DescribeSQLTuningAdvicesRequest) {
	request = &DescribeSQLTuningAdvicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeSQLTuningAdvices", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSQLTuningAdvicesResponse creates a response to parse from DescribeSQLTuningAdvices response
func CreateDescribeSQLTuningAdvicesResponse() (response *DescribeSQLTuningAdvicesResponse) {
	response = &DescribeSQLTuningAdvicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
