package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAvailableCpuResource invokes the oceanbasepro.DescribeAvailableCpuResource API synchronously
func (client *Client) DescribeAvailableCpuResource(request *DescribeAvailableCpuResourceRequest) (response *DescribeAvailableCpuResourceResponse, err error) {
	response = CreateDescribeAvailableCpuResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAvailableCpuResourceWithChan invokes the oceanbasepro.DescribeAvailableCpuResource API asynchronously
func (client *Client) DescribeAvailableCpuResourceWithChan(request *DescribeAvailableCpuResourceRequest) (<-chan *DescribeAvailableCpuResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeAvailableCpuResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAvailableCpuResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAvailableCpuResourceWithCallback invokes the oceanbasepro.DescribeAvailableCpuResource API asynchronously
func (client *Client) DescribeAvailableCpuResourceWithCallback(request *DescribeAvailableCpuResourceRequest, callback func(response *DescribeAvailableCpuResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAvailableCpuResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeAvailableCpuResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAvailableCpuResourceRequest is the request struct for api DescribeAvailableCpuResource
type DescribeAvailableCpuResourceRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	ModifyType string `position:"Body" name:"ModifyType"`
	TenantId   string `position:"Body" name:"TenantId"`
}

// DescribeAvailableCpuResourceResponse is the response struct for api DescribeAvailableCpuResource
type DescribeAvailableCpuResourceResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeAvailableCpuResourceRequest creates a request to invoke DescribeAvailableCpuResource API
func CreateDescribeAvailableCpuResourceRequest() (request *DescribeAvailableCpuResourceRequest) {
	request = &DescribeAvailableCpuResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeAvailableCpuResource", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAvailableCpuResourceResponse creates a response to parse from DescribeAvailableCpuResource response
func CreateDescribeAvailableCpuResourceResponse() (response *DescribeAvailableCpuResourceResponse) {
	response = &DescribeAvailableCpuResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
