package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateProject invokes the oceanbasepro.CreateProject API synchronously
func (client *Client) CreateProject(request *CreateProjectRequest) (response *CreateProjectResponse, err error) {
	response = CreateCreateProjectResponse()
	err = client.DoAction(request, response)
	return
}

// CreateProjectWithChan invokes the oceanbasepro.CreateProject API asynchronously
func (client *Client) CreateProjectWithChan(request *CreateProjectRequest) (<-chan *CreateProjectResponse, <-chan error) {
	responseChan := make(chan *CreateProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateProjectWithCallback invokes the oceanbasepro.CreateProject API asynchronously
func (client *Client) CreateProjectWithCallback(request *CreateProjectRequest, callback func(response *CreateProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateProjectResponse
		var err error
		defer close(result)
		response, err = client.CreateProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateProjectRequest is the request struct for api CreateProject
type CreateProjectRequest struct {
	*requests.RpcRequest
	SinkEndpointId            string                                 `position:"Body" name:"SinkEndpointId"`
	UseOss                    requests.Boolean                       `position:"Body" name:"UseOss"`
	OssKey                    string                                 `position:"Body" name:"OssKey"`
	SourceEndpointId          string                                 `position:"Body" name:"SourceEndpointId"`
	Type                      string                                 `position:"Body" name:"Type"`
	FullTransferConfig        CreateProjectFullTransferConfig        `position:"Body" name:"FullTransferConfig"  type:"Struct"`
	EnableStructTransfer      requests.Boolean                       `position:"Body" name:"EnableStructTransfer"`
	TransferMapping           CreateProjectTransferMapping           `position:"Body" name:"TransferMapping"  type:"Struct"`
	WorkerGradeId             string                                 `position:"Body" name:"WorkerGradeId"`
	Id                        string                                 `position:"Body" name:"Id"`
	CommonTransferConfig      CreateProjectCommonTransferConfig      `position:"Body" name:"CommonTransferConfig"  type:"Struct"`
	StructTransferConfig      CreateProjectStructTransferConfig      `position:"Body" name:"StructTransferConfig"  type:"Struct"`
	ReverseIncrTransferConfig CreateProjectReverseIncrTransferConfig `position:"Body" name:"ReverseIncrTransferConfig"  type:"Struct"`
	EnableIncrTransfer        requests.Boolean                       `position:"Body" name:"EnableIncrTransfer"`
	EnableFullTransfer        requests.Boolean                       `position:"Body" name:"EnableFullTransfer"`
	EnableFullVerify          requests.Boolean                       `position:"Body" name:"EnableFullVerify"`
	Name                      string                                 `position:"Body" name:"Name"`
	LabelIds                  *[]string                              `position:"Body" name:"LabelIds"  type:"Json"`
	IncrTransferConfig        CreateProjectIncrTransferConfig        `position:"Body" name:"IncrTransferConfig"  type:"Struct"`
	EnableReverseIncrTransfer requests.Boolean                       `position:"Body" name:"EnableReverseIncrTransfer"`
}

// CreateProjectFullTransferConfig is a repeated param struct in CreateProjectRequest
type CreateProjectFullTransferConfig struct {
	NonePkUkTruncateDstTable string `name:"NonePkUkTruncateDstTable"`
	ThrottleRps              string `name:"ThrottleRps"`
	FullVerifySpeedMode      string `name:"FullVerifySpeedMode"`
	WriteWorkerNum           string `name:"WriteWorkerNum"`
	ReadWorkerNum            string `name:"ReadWorkerNum"`
	FullTransferSpeedMode    string `name:"FullTransferSpeedMode"`
	AllowDestTableNotEmpty   string `name:"AllowDestTableNotEmpty"`
	ThrottleIOPS             string `name:"ThrottleIOPS"`
}

// CreateProjectTransferMapping is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMapping struct {
	Mode                  string                                            `name:"Mode"`
	Databases             *[]CreateProjectTransferMappingDatabasesItem      `name:"Databases" type:"Repeated"`
	TableAndViewBlackList *[]string                                         `name:"TableAndViewBlackList" type:"Repeated"`
	DatabasesBlack        *[]CreateProjectTransferMappingDatabasesBlackItem `name:"DatabasesBlack" type:"Repeated"`
	TableAndViewWhiteList *[]string                                         `name:"TableAndViewWhiteList" type:"Repeated"`
}

// CreateProjectCommonTransferConfig is a repeated param struct in CreateProjectRequest
type CreateProjectCommonTransferConfig struct {
	MqPartition            string                                                `name:"MqPartition"`
	SyncSchemaColumnName   string                                                `name:"SyncSchemaColumnName"`
	ActiveActive           string                                                `name:"ActiveActive"`
	SinkStoreFormat        string                                                `name:"SinkStoreFormat"`
	RocketMqEnableMsgTrace string                                                `name:"RocketMqEnableMsgTrace"`
	CustomColumns          *[]CreateProjectCommonTransferConfigCustomColumnsItem `name:"CustomColumns" type:"Repeated"`
	RocketMqProducerGroup  string                                                `name:"RocketMqProducerGroup"`
	MqPartitionMode        string                                                `name:"MqPartitionMode"`
	RocketMqSendMsgTimeout string                                                `name:"RocketMqSendMsgTimeout"`
	TableCategory          string                                                `name:"TableCategory"`
	DatahubTopicType       string                                                `name:"DatahubTopicType"`
	RocketMqMsgTags        string                                                `name:"RocketMqMsgTags"`
	DataWorksBusinessName  string                                                `name:"DataWorksBusinessName"`
	SourceStoreFormat      string                                                `name:"SourceStoreFormat"`
	SyncSchema             string                                                `name:"SyncSchema"`
	MqSerializerType       string                                                `name:"MqSerializerType"`
}

// CreateProjectStructTransferConfig is a repeated param struct in CreateProjectRequest
type CreateProjectStructTransferConfig struct {
	ByteCharConvertStrategy string `name:"ByteCharConvertStrategy"`
	DeferIndexCreation      string `name:"DeferIndexCreation"`
}

// CreateProjectReverseIncrTransferConfig is a repeated param struct in CreateProjectRequest
type CreateProjectReverseIncrTransferConfig struct {
	ThrottleRps               string    `name:"ThrottleRps"`
	EnableSequencingWithinTxn string    `name:"EnableSequencingWithinTxn"`
	SupportDDLTypes           *[]string `name:"SupportDDLTypes" type:"Repeated"`
	StoreLogKeptHour          string    `name:"StoreLogKeptHour"`
	StartTimestamp            string    `name:"StartTimestamp"`
	RecordTypeWhiteList       *[]string `name:"RecordTypeWhiteList" type:"Repeated"`
	IncrSyncConcurrency       string    `name:"IncrSyncConcurrency"`
	EnableIncrSyncStatistics  string    `name:"EnableIncrSyncStatistics"`
	ThrottleIOPS              string    `name:"ThrottleIOPS"`
}

// CreateProjectIncrTransferConfig is a repeated param struct in CreateProjectRequest
type CreateProjectIncrTransferConfig struct {
	ThrottleRps               string    `name:"ThrottleRps"`
	EnableSequencingWithinTxn string    `name:"EnableSequencingWithinTxn"`
	SupportDDLTypes           *[]string `name:"SupportDDLTypes" type:"Repeated"`
	StoreLogKeptHour          string    `name:"StoreLogKeptHour"`
	StartTimestamp            string    `name:"StartTimestamp"`
	RecordTypeWhiteList       *[]string `name:"RecordTypeWhiteList" type:"Repeated"`
	IncrSyncConcurrency       string    `name:"IncrSyncConcurrency"`
	EnableIncrSyncStatistics  string    `name:"EnableIncrSyncStatistics"`
	ThrottleIOPS              string    `name:"ThrottleIOPS"`
}

// CreateProjectTransferMappingDatabasesItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesItem struct {
	MappedName     string                                                         `name:"MappedName"`
	SpecificViews  *[]CreateProjectTransferMappingDatabasesItemSpecificViewsItem  `name:"SpecificViews" type:"Repeated"`
	Tables         *[]CreateProjectTransferMappingDatabasesItemTablesItem         `name:"Tables" type:"Repeated"`
	ClusterName    string                                                         `name:"ClusterName"`
	Name           string                                                         `name:"Name"`
	TenantName     string                                                         `name:"TenantName"`
	Id             string                                                         `name:"Id"`
	SpecificTables *[]CreateProjectTransferMappingDatabasesItemSpecificTablesItem `name:"SpecificTables" type:"Repeated"`
	Views          *[]CreateProjectTransferMappingDatabasesItemViewsItem          `name:"Views" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesBlackItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesBlackItem struct {
	MappedName     string                                                              `name:"MappedName"`
	SpecificViews  *[]CreateProjectTransferMappingDatabasesBlackItemSpecificViewsItem  `name:"SpecificViews" type:"Repeated"`
	Tables         *[]CreateProjectTransferMappingDatabasesBlackItemTablesItem         `name:"Tables" type:"Repeated"`
	ClusterName    string                                                              `name:"ClusterName"`
	Name           string                                                              `name:"Name"`
	TenantName     string                                                              `name:"TenantName"`
	Id             string                                                              `name:"Id"`
	SpecificTables *[]CreateProjectTransferMappingDatabasesBlackItemSpecificTablesItem `name:"SpecificTables" type:"Repeated"`
	Views          *[]CreateProjectTransferMappingDatabasesBlackItemViewsItem          `name:"Views" type:"Repeated"`
}

// CreateProjectCommonTransferConfigCustomColumnsItem is a repeated param struct in CreateProjectRequest
type CreateProjectCommonTransferConfigCustomColumnsItem struct {
	Expression string `name:"Expression"`
	ColumnName string `name:"ColumnName"`
}

// CreateProjectTransferMappingDatabasesItemSpecificViewsItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesItemSpecificViewsItem struct {
	MappedName     string                                                                   `name:"MappedName"`
	FilterColumns  *[]string                                                                `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectTransferMappingDatabasesItemSpecificViewsItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                                   `name:"Name"`
	WhereClause    string                                                                   `name:"WhereClause"`
	Id             string                                                                   `name:"Id"`
	ShardColumns   *[]string                                                                `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesItemTablesItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesItemTablesItem struct {
	MappedName     string                                                            `name:"MappedName"`
	FilterColumns  *[]string                                                         `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectTransferMappingDatabasesItemTablesItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                            `name:"Name"`
	WhereClause    string                                                            `name:"WhereClause"`
	Id             string                                                            `name:"Id"`
	ShardColumns   *[]string                                                         `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesItemSpecificTablesItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesItemSpecificTablesItem struct {
	MappedName     string                                                                    `name:"MappedName"`
	FilterColumns  *[]string                                                                 `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectTransferMappingDatabasesItemSpecificTablesItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                                    `name:"Name"`
	WhereClause    string                                                                    `name:"WhereClause"`
	Id             string                                                                    `name:"Id"`
	ShardColumns   *[]string                                                                 `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesItemViewsItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesItemViewsItem struct {
	MappedName     string                                                           `name:"MappedName"`
	FilterColumns  *[]string                                                        `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectTransferMappingDatabasesItemViewsItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                           `name:"Name"`
	WhereClause    string                                                           `name:"WhereClause"`
	Id             string                                                           `name:"Id"`
	ShardColumns   *[]string                                                        `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesBlackItemSpecificViewsItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesBlackItemSpecificViewsItem struct {
	MappedName     string                                                                        `name:"MappedName"`
	FilterColumns  *[]string                                                                     `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectTransferMappingDatabasesBlackItemSpecificViewsItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                                        `name:"Name"`
	WhereClause    string                                                                        `name:"WhereClause"`
	Id             string                                                                        `name:"Id"`
	ShardColumns   *[]string                                                                     `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesBlackItemTablesItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesBlackItemTablesItem struct {
	MappedName     string                                                                 `name:"MappedName"`
	FilterColumns  *[]string                                                              `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectTransferMappingDatabasesBlackItemTablesItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                                 `name:"Name"`
	WhereClause    string                                                                 `name:"WhereClause"`
	Id             string                                                                 `name:"Id"`
	ShardColumns   *[]string                                                              `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesBlackItemSpecificTablesItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesBlackItemSpecificTablesItem struct {
	MappedName     string                                                                         `name:"MappedName"`
	FilterColumns  *[]string                                                                      `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectTransferMappingDatabasesBlackItemSpecificTablesItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                                         `name:"Name"`
	WhereClause    string                                                                         `name:"WhereClause"`
	Id             string                                                                         `name:"Id"`
	ShardColumns   *[]string                                                                      `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesBlackItemViewsItem is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesBlackItemViewsItem struct {
	MappedName     string                                                                `name:"MappedName"`
	FilterColumns  *[]string                                                             `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectTransferMappingDatabasesBlackItemViewsItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                                `name:"Name"`
	WhereClause    string                                                                `name:"WhereClause"`
	Id             string                                                                `name:"Id"`
	ShardColumns   *[]string                                                             `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesItemSpecificViewsItemAdbTableSchema is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesItemSpecificViewsItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesItemTablesItemAdbTableSchema is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesItemTablesItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesItemSpecificTablesItemAdbTableSchema is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesItemSpecificTablesItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesItemViewsItemAdbTableSchema is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesItemViewsItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesBlackItemSpecificViewsItemAdbTableSchema is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesBlackItemSpecificViewsItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesBlackItemTablesItemAdbTableSchema is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesBlackItemTablesItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesBlackItemSpecificTablesItemAdbTableSchema is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesBlackItemSpecificTablesItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectTransferMappingDatabasesBlackItemViewsItemAdbTableSchema is a repeated param struct in CreateProjectRequest
type CreateProjectTransferMappingDatabasesBlackItemViewsItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectResponse is the response struct for api CreateProject
type CreateProjectResponse struct {
	*responses.BaseResponse
}

// CreateCreateProjectRequest creates a request to invoke CreateProject API
func CreateCreateProjectRequest() (request *CreateProjectRequest) {
	request = &CreateProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateProject", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateProjectResponse creates a response to parse from CreateProject response
func CreateCreateProjectResponse() (response *CreateProjectResponse) {
	response = &CreateProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
