package mseap

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetRedisValue invokes the mseap.SetRedisValue API synchronously
func (client *Client) SetRedisValue(request *SetRedisValueRequest) (response *SetRedisValueResponse, err error) {
	response = CreateSetRedisValueResponse()
	err = client.DoAction(request, response)
	return
}

// SetRedisValueWithChan invokes the mseap.SetRedisValue API asynchronously
func (client *Client) SetRedisValueWithChan(request *SetRedisValueRequest) (<-chan *SetRedisValueResponse, <-chan error) {
	responseChan := make(chan *SetRedisValueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetRedisValue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetRedisValueWithCallback invokes the mseap.SetRedisValue API asynchronously
func (client *Client) SetRedisValueWithCallback(request *SetRedisValueRequest, callback func(response *SetRedisValueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetRedisValueResponse
		var err error
		defer close(result)
		response, err = client.SetRedisValue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetRedisValueRequest is the request struct for api SetRedisValue
type SetRedisValueRequest struct {
	*requests.RpcRequest
	UserCallerParentId requests.Integer `position:"Query" name:"UserCallerParentId"`
	ApiType            string           `position:"Query" name:"ApiType"`
	Timeout            requests.Integer `position:"Query" name:"Timeout"`
	UserMfaPresent     requests.Boolean `position:"Query" name:"UserMfaPresent"`
	UserKp             string           `position:"Query" name:"UserKp"`
	Lang               string           `position:"Query" name:"Lang"`
	Value              string           `position:"Query" name:"Value"`
	Key                string           `position:"Query" name:"Key"`
	UserCallerType     string           `position:"Query" name:"UserCallerType"`
	UserSecurityToken  string           `position:"Query" name:"UserSecurityToken"`
	UserAccessKeyId    string           `position:"Query" name:"UserAccessKeyId"`
	AliyunKp           string           `position:"Query" name:"AliyunKp"`
	UserBid            string           `position:"Query" name:"UserBid"`
	OriginalRequest    string           `position:"Query" name:"OriginalRequest"`
	RequestId          string           `position:"Query" name:"RequestId"`
	UserClientIp       string           `position:"Query" name:"UserClientIp"`
	Bid                string           `position:"Query" name:"Bid"`
}

// SetRedisValueResponse is the response struct for api SetRedisValue
type SetRedisValueResponse struct {
	*responses.BaseResponse
	AllowRetry     bool   `json:"AllowRetry" xml:"AllowRetry"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Module         bool   `json:"Module" xml:"Module"`
	Success        bool   `json:"Success" xml:"Success"`
	AppName        string `json:"AppName" xml:"AppName"`
}

// CreateSetRedisValueRequest creates a request to invoke SetRedisValue API
func CreateSetRedisValueRequest() (request *SetRedisValueRequest) {
	request = &SetRedisValueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mseap", "2021-01-18", "SetRedisValue", "", "")
	request.Method = requests.POST
	return
}

// CreateSetRedisValueResponse creates a response to parse from SetRedisValue response
func CreateSetRedisValueResponse() (response *SetRedisValueResponse) {
	response = &SetRedisValueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
