package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNacosInstance invokes the mse.DeleteNacosInstance API synchronously
func (client *Client) DeleteNacosInstance(request *DeleteNacosInstanceRequest) (response *DeleteNacosInstanceResponse, err error) {
	response = CreateDeleteNacosInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNacosInstanceWithChan invokes the mse.DeleteNacosInstance API asynchronously
func (client *Client) DeleteNacosInstanceWithChan(request *DeleteNacosInstanceRequest) (<-chan *DeleteNacosInstanceResponse, <-chan error) {
	responseChan := make(chan *DeleteNacosInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNacosInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNacosInstanceWithCallback invokes the mse.DeleteNacosInstance API asynchronously
func (client *Client) DeleteNacosInstanceWithCallback(request *DeleteNacosInstanceRequest, callback func(response *DeleteNacosInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNacosInstanceResponse
		var err error
		defer close(result)
		response, err = client.DeleteNacosInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNacosInstanceRequest is the request struct for api DeleteNacosInstance
type DeleteNacosInstanceRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	ClusterName    string           `position:"Query" name:"ClusterName"`
	Ephemeral      requests.Boolean `position:"Query" name:"Ephemeral"`
	NamespaceId    string           `position:"Query" name:"NamespaceId"`
	ServiceName    string           `position:"Query" name:"ServiceName"`
	Ip             string           `position:"Query" name:"Ip"`
	GroupName      string           `position:"Query" name:"GroupName"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	Port           requests.Integer `position:"Query" name:"Port"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// DeleteNacosInstanceResponse is the response struct for api DeleteNacosInstance
type DeleteNacosInstanceResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateDeleteNacosInstanceRequest creates a request to invoke DeleteNacosInstance API
func CreateDeleteNacosInstanceRequest() (request *DeleteNacosInstanceRequest) {
	request = &DeleteNacosInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteNacosInstance", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteNacosInstanceResponse creates a response to parse from DeleteNacosInstance response
func CreateDeleteNacosInstanceResponse() (response *DeleteNacosInstanceResponse) {
	response = &DeleteNacosInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
