package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGatewayService invokes the mse.DeleteGatewayService API synchronously
func (client *Client) DeleteGatewayService(request *DeleteGatewayServiceRequest) (response *DeleteGatewayServiceResponse, err error) {
	response = CreateDeleteGatewayServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGatewayServiceWithChan invokes the mse.DeleteGatewayService API asynchronously
func (client *Client) DeleteGatewayServiceWithChan(request *DeleteGatewayServiceRequest) (<-chan *DeleteGatewayServiceResponse, <-chan error) {
	responseChan := make(chan *DeleteGatewayServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGatewayService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGatewayServiceWithCallback invokes the mse.DeleteGatewayService API asynchronously
func (client *Client) DeleteGatewayServiceWithCallback(request *DeleteGatewayServiceRequest, callback func(response *DeleteGatewayServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGatewayServiceResponse
		var err error
		defer close(result)
		response, err = client.DeleteGatewayService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGatewayServiceRequest is the request struct for api DeleteGatewayService
type DeleteGatewayServiceRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	GatewayId       requests.Integer `position:"Query" name:"GatewayId"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	ServiceId       string           `position:"Query" name:"ServiceId"`
}

// DeleteGatewayServiceResponse is the response struct for api DeleteGatewayService
type DeleteGatewayServiceResponse struct {
	*responses.BaseResponse
	RequestId      string                     `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                     `json:"Message" xml:"Message"`
	Code           int                        `json:"Code" xml:"Code"`
	Success        bool                       `json:"Success" xml:"Success"`
	Data           DataInDeleteGatewayService `json:"Data" xml:"Data"`
}

// CreateDeleteGatewayServiceRequest creates a request to invoke DeleteGatewayService API
func CreateDeleteGatewayServiceRequest() (request *DeleteGatewayServiceRequest) {
	request = &DeleteGatewayServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteGatewayService", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteGatewayServiceResponse creates a response to parse from DeleteGatewayService response
func CreateDeleteGatewayServiceResponse() (response *DeleteGatewayServiceResponse) {
	response = &DeleteGatewayServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
