package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddBlackWhiteList invokes the mse.AddBlackWhiteList API synchronously
func (client *Client) AddBlackWhiteList(request *AddBlackWhiteListRequest) (response *AddBlackWhiteListResponse, err error) {
	response = CreateAddBlackWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// AddBlackWhiteListWithChan invokes the mse.AddBlackWhiteList API asynchronously
func (client *Client) AddBlackWhiteListWithChan(request *AddBlackWhiteListRequest) (<-chan *AddBlackWhiteListResponse, <-chan error) {
	responseChan := make(chan *AddBlackWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddBlackWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddBlackWhiteListWithCallback invokes the mse.AddBlackWhiteList API asynchronously
func (client *Client) AddBlackWhiteListWithCallback(request *AddBlackWhiteListRequest, callback func(response *AddBlackWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddBlackWhiteListResponse
		var err error
		defer close(result)
		response, err = client.AddBlackWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddBlackWhiteListRequest is the request struct for api AddBlackWhiteList
type AddBlackWhiteListRequest struct {
	*requests.RpcRequest
	Note               string           `position:"Query" name:"Note"`
	MseSessionId       string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId    string           `position:"Query" name:"GatewayUniqueId"`
	Type               string           `position:"Query" name:"Type"`
	Content            string           `position:"Query" name:"Content"`
	IsWhite            requests.Boolean `position:"Query" name:"IsWhite"`
	ResourceIdJsonList string           `position:"Query" name:"ResourceIdJsonList"`
	ResourceType       string           `position:"Query" name:"ResourceType"`
	Name               string           `position:"Query" name:"Name"`
	AcceptLanguage     string           `position:"Query" name:"AcceptLanguage"`
	Status             string           `position:"Query" name:"Status"`
}

// AddBlackWhiteListResponse is the response struct for api AddBlackWhiteList
type AddBlackWhiteListResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateAddBlackWhiteListRequest creates a request to invoke AddBlackWhiteList API
func CreateAddBlackWhiteListRequest() (request *AddBlackWhiteListRequest) {
	request = &AddBlackWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddBlackWhiteList", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddBlackWhiteListResponse creates a response to parse from AddBlackWhiteList response
func CreateAddBlackWhiteListResponse() (response *AddBlackWhiteListResponse) {
	response = &AddBlackWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
