package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadMcubeRsaKey invokes the mpaas.UploadMcubeRsaKey API synchronously
func (client *Client) UploadMcubeRsaKey(request *UploadMcubeRsaKeyRequest) (response *UploadMcubeRsaKeyResponse, err error) {
	response = CreateUploadMcubeRsaKeyResponse()
	err = client.DoAction(request, response)
	return
}

// UploadMcubeRsaKeyWithChan invokes the mpaas.UploadMcubeRsaKey API asynchronously
func (client *Client) UploadMcubeRsaKeyWithChan(request *UploadMcubeRsaKeyRequest) (<-chan *UploadMcubeRsaKeyResponse, <-chan error) {
	responseChan := make(chan *UploadMcubeRsaKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadMcubeRsaKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadMcubeRsaKeyWithCallback invokes the mpaas.UploadMcubeRsaKey API asynchronously
func (client *Client) UploadMcubeRsaKeyWithCallback(request *UploadMcubeRsaKeyRequest, callback func(response *UploadMcubeRsaKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadMcubeRsaKeyResponse
		var err error
		defer close(result)
		response, err = client.UploadMcubeRsaKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadMcubeRsaKeyRequest is the request struct for api UploadMcubeRsaKey
type UploadMcubeRsaKeyRequest struct {
	*requests.RpcRequest
	OnexFlag    requests.Boolean `position:"Body" name:"OnexFlag"`
	TenantId    string           `position:"Body" name:"TenantId"`
	AppId       string           `position:"Body" name:"AppId"`
	FileUrl     string           `position:"Body" name:"FileUrl"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// UploadMcubeRsaKeyResponse is the response struct for api UploadMcubeRsaKey
type UploadMcubeRsaKeyResponse struct {
	*responses.BaseResponse
	ResultMessage   string          `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode      string          `json:"ResultCode" xml:"ResultCode"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	UploadRsaResult UploadRsaResult `json:"UploadRsaResult" xml:"UploadRsaResult"`
}

// CreateUploadMcubeRsaKeyRequest creates a request to invoke UploadMcubeRsaKey API
func CreateUploadMcubeRsaKeyRequest() (request *UploadMcubeRsaKeyRequest) {
	request = &UploadMcubeRsaKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "UploadMcubeRsaKey", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadMcubeRsaKeyResponse creates a response to parse from UploadMcubeRsaKey response
func CreateUploadMcubeRsaKeyResponse() (response *UploadMcubeRsaKeyResponse) {
	response = &UploadMcubeRsaKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
