package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserAppUploadProcessInMsa invokes the mpaas.GetUserAppUploadProcessInMsa API synchronously
func (client *Client) GetUserAppUploadProcessInMsa(request *GetUserAppUploadProcessInMsaRequest) (response *GetUserAppUploadProcessInMsaResponse, err error) {
	response = CreateGetUserAppUploadProcessInMsaResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserAppUploadProcessInMsaWithChan invokes the mpaas.GetUserAppUploadProcessInMsa API asynchronously
func (client *Client) GetUserAppUploadProcessInMsaWithChan(request *GetUserAppUploadProcessInMsaRequest) (<-chan *GetUserAppUploadProcessInMsaResponse, <-chan error) {
	responseChan := make(chan *GetUserAppUploadProcessInMsaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserAppUploadProcessInMsa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserAppUploadProcessInMsaWithCallback invokes the mpaas.GetUserAppUploadProcessInMsa API asynchronously
func (client *Client) GetUserAppUploadProcessInMsaWithCallback(request *GetUserAppUploadProcessInMsaRequest, callback func(response *GetUserAppUploadProcessInMsaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserAppUploadProcessInMsaResponse
		var err error
		defer close(result)
		response, err = client.GetUserAppUploadProcessInMsa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserAppUploadProcessInMsaRequest is the request struct for api GetUserAppUploadProcessInMsa
type GetUserAppUploadProcessInMsaRequest struct {
	*requests.RpcRequest
	TenantId    string           `position:"Body" name:"TenantId"`
	Id          requests.Integer `position:"Body" name:"Id"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// GetUserAppUploadProcessInMsaResponse is the response struct for api GetUserAppUploadProcessInMsa
type GetUserAppUploadProcessInMsaResponse struct {
	*responses.BaseResponse
	ResultMessage string                                      `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                      `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                      `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInGetUserAppUploadProcessInMsa `json:"ResultContent" xml:"ResultContent"`
}

// CreateGetUserAppUploadProcessInMsaRequest creates a request to invoke GetUserAppUploadProcessInMsa API
func CreateGetUserAppUploadProcessInMsaRequest() (request *GetUserAppUploadProcessInMsaRequest) {
	request = &GetUserAppUploadProcessInMsaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetUserAppUploadProcessInMsa", "", "")
	request.Method = requests.POST
	return
}

// CreateGetUserAppUploadProcessInMsaResponse creates a response to parse from GetUserAppUploadProcessInMsa response
func CreateGetUserAppUploadProcessInMsaResponse() (response *GetUserAppUploadProcessInMsaResponse) {
	response = &GetUserAppUploadProcessInMsaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
