package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBaaSFabricOrganization invokes the lto.ListBaaSFabricOrganization API synchronously
func (client *Client) ListBaaSFabricOrganization(request *ListBaaSFabricOrganizationRequest) (response *ListBaaSFabricOrganizationResponse, err error) {
	response = CreateListBaaSFabricOrganizationResponse()
	err = client.DoAction(request, response)
	return
}

// ListBaaSFabricOrganizationWithChan invokes the lto.ListBaaSFabricOrganization API asynchronously
func (client *Client) ListBaaSFabricOrganizationWithChan(request *ListBaaSFabricOrganizationRequest) (<-chan *ListBaaSFabricOrganizationResponse, <-chan error) {
	responseChan := make(chan *ListBaaSFabricOrganizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBaaSFabricOrganization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBaaSFabricOrganizationWithCallback invokes the lto.ListBaaSFabricOrganization API asynchronously
func (client *Client) ListBaaSFabricOrganizationWithCallback(request *ListBaaSFabricOrganizationRequest, callback func(response *ListBaaSFabricOrganizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBaaSFabricOrganizationResponse
		var err error
		defer close(result)
		response, err = client.ListBaaSFabricOrganization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBaaSFabricOrganizationRequest is the request struct for api ListBaaSFabricOrganization
type ListBaaSFabricOrganizationRequest struct {
	*requests.RpcRequest
	BaaSFabricChannelId string `position:"Query" name:"BaaSFabricChannelId"`
}

// ListBaaSFabricOrganizationResponse is the response struct for api ListBaaSFabricOrganization
type ListBaaSFabricOrganizationResponse struct {
	*responses.BaseResponse
	Code           string                       `json:"Code" xml:"Code"`
	HttpStatusCode int                          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                       `json:"Message" xml:"Message"`
	RequestId      string                       `json:"RequestId" xml:"RequestId"`
	Success        bool                         `json:"Success" xml:"Success"`
	Data           []BaaSFabricOrganizationInfo `json:"Data" xml:"Data"`
}

// CreateListBaaSFabricOrganizationRequest creates a request to invoke ListBaaSFabricOrganization API
func CreateListBaaSFabricOrganizationRequest() (request *ListBaaSFabricOrganizationRequest) {
	request = &ListBaaSFabricOrganizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListBaaSFabricOrganization", "", "")
	request.Method = requests.POST
	return
}

// CreateListBaaSFabricOrganizationResponse creates a response to parse from ListBaaSFabricOrganization response
func CreateListBaaSFabricOrganizationResponse() (response *ListBaaSFabricOrganizationResponse) {
	response = &ListBaaSFabricOrganizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
