package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FreezeMember invokes the lto.FreezeMember API synchronously
func (client *Client) FreezeMember(request *FreezeMemberRequest) (response *FreezeMemberResponse, err error) {
	response = CreateFreezeMemberResponse()
	err = client.DoAction(request, response)
	return
}

// FreezeMemberWithChan invokes the lto.FreezeMember API asynchronously
func (client *Client) FreezeMemberWithChan(request *FreezeMemberRequest) (<-chan *FreezeMemberResponse, <-chan error) {
	responseChan := make(chan *FreezeMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FreezeMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FreezeMemberWithCallback invokes the lto.FreezeMember API asynchronously
func (client *Client) FreezeMemberWithCallback(request *FreezeMemberRequest, callback func(response *FreezeMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FreezeMemberResponse
		var err error
		defer close(result)
		response, err = client.FreezeMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FreezeMemberRequest is the request struct for api FreezeMember
type FreezeMemberRequest struct {
	*requests.RpcRequest
	MemberId string `position:"Query" name:"MemberId"`
}

// FreezeMemberResponse is the response struct for api FreezeMember
type FreezeMemberResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateFreezeMemberRequest creates a request to invoke FreezeMember API
func CreateFreezeMemberRequest() (request *FreezeMemberRequest) {
	request = &FreezeMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "FreezeMember", "", "")
	request.Method = requests.POST
	return
}

// CreateFreezeMemberResponse creates a response to parse from FreezeMember response
func CreateFreezeMemberResponse() (response *FreezeMemberResponse) {
	response = &FreezeMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
