package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AuthorizeDeviceGroupBizChain invokes the lto.AuthorizeDeviceGroupBizChain API synchronously
func (client *Client) AuthorizeDeviceGroupBizChain(request *AuthorizeDeviceGroupBizChainRequest) (response *AuthorizeDeviceGroupBizChainResponse, err error) {
	response = CreateAuthorizeDeviceGroupBizChainResponse()
	err = client.DoAction(request, response)
	return
}

// AuthorizeDeviceGroupBizChainWithChan invokes the lto.AuthorizeDeviceGroupBizChain API asynchronously
func (client *Client) AuthorizeDeviceGroupBizChainWithChan(request *AuthorizeDeviceGroupBizChainRequest) (<-chan *AuthorizeDeviceGroupBizChainResponse, <-chan error) {
	responseChan := make(chan *AuthorizeDeviceGroupBizChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AuthorizeDeviceGroupBizChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AuthorizeDeviceGroupBizChainWithCallback invokes the lto.AuthorizeDeviceGroupBizChain API asynchronously
func (client *Client) AuthorizeDeviceGroupBizChainWithCallback(request *AuthorizeDeviceGroupBizChainRequest, callback func(response *AuthorizeDeviceGroupBizChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AuthorizeDeviceGroupBizChainResponse
		var err error
		defer close(result)
		response, err = client.AuthorizeDeviceGroupBizChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AuthorizeDeviceGroupBizChainRequest is the request struct for api AuthorizeDeviceGroupBizChain
type AuthorizeDeviceGroupBizChainRequest struct {
	*requests.RpcRequest
	BizChainIdList string `position:"Query" name:"BizChainIdList"`
	DeviceGroupId  string `position:"Query" name:"DeviceGroupId"`
}

// AuthorizeDeviceGroupBizChainResponse is the response struct for api AuthorizeDeviceGroupBizChain
type AuthorizeDeviceGroupBizChainResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAuthorizeDeviceGroupBizChainRequest creates a request to invoke AuthorizeDeviceGroupBizChain API
func CreateAuthorizeDeviceGroupBizChainRequest() (request *AuthorizeDeviceGroupBizChainRequest) {
	request = &AuthorizeDeviceGroupBizChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "AuthorizeDeviceGroupBizChain", "", "")
	request.Method = requests.POST
	return
}

// CreateAuthorizeDeviceGroupBizChainResponse creates a response to parse from AuthorizeDeviceGroupBizChain response
func CreateAuthorizeDeviceGroupBizChainResponse() (response *AuthorizeDeviceGroupBizChainResponse) {
	response = &AuthorizeDeviceGroupBizChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
