package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMeterLiveBypassDuration invokes the live.DescribeMeterLiveBypassDuration API synchronously
func (client *Client) DescribeMeterLiveBypassDuration(request *DescribeMeterLiveBypassDurationRequest) (response *DescribeMeterLiveBypassDurationResponse, err error) {
	response = CreateDescribeMeterLiveBypassDurationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMeterLiveBypassDurationWithChan invokes the live.DescribeMeterLiveBypassDuration API asynchronously
func (client *Client) DescribeMeterLiveBypassDurationWithChan(request *DescribeMeterLiveBypassDurationRequest) (<-chan *DescribeMeterLiveBypassDurationResponse, <-chan error) {
	responseChan := make(chan *DescribeMeterLiveBypassDurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMeterLiveBypassDuration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMeterLiveBypassDurationWithCallback invokes the live.DescribeMeterLiveBypassDuration API asynchronously
func (client *Client) DescribeMeterLiveBypassDurationWithCallback(request *DescribeMeterLiveBypassDurationRequest, callback func(response *DescribeMeterLiveBypassDurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMeterLiveBypassDurationResponse
		var err error
		defer close(result)
		response, err = client.DescribeMeterLiveBypassDuration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMeterLiveBypassDurationRequest is the request struct for api DescribeMeterLiveBypassDuration
type DescribeMeterLiveBypassDurationRequest struct {
	*requests.RpcRequest
	EndTime   string `position:"Query" name:"EndTime"`
	StartTime string `position:"Query" name:"StartTime"`
	AppId     string `position:"Query" name:"AppId"`
	Interval  string `position:"Query" name:"Interval"`
}

// DescribeMeterLiveBypassDurationResponse is the response struct for api DescribeMeterLiveBypassDuration
type DescribeMeterLiveBypassDurationResponse struct {
	*responses.BaseResponse
	AudioSummaryDuration       int64      `json:"AudioSummaryDuration" xml:"AudioSummaryDuration"`
	RequestId                  string     `json:"RequestId" xml:"RequestId"`
	SingleAudioSummaryDuration int64      `json:"SingleAudioSummaryDuration" xml:"SingleAudioSummaryDuration"`
	SingleVideoSummaryDuration int64      `json:"SingleVideoSummaryDuration" xml:"SingleVideoSummaryDuration"`
	TotalSummaryDuration       int64      `json:"TotalSummaryDuration" xml:"TotalSummaryDuration"`
	V480SummaryDuration        int64      `json:"V480SummaryDuration" xml:"V480SummaryDuration"`
	V720SummaryDuration        int64      `json:"V720SummaryDuration" xml:"V720SummaryDuration"`
	V1080SummaryDuration       int64      `json:"V1080SummaryDuration" xml:"V1080SummaryDuration"`
	Data                       []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeMeterLiveBypassDurationRequest creates a request to invoke DescribeMeterLiveBypassDuration API
func CreateDescribeMeterLiveBypassDurationRequest() (request *DescribeMeterLiveBypassDurationRequest) {
	request = &DescribeMeterLiveBypassDurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeMeterLiveBypassDuration", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMeterLiveBypassDurationResponse creates a response to parse from DescribeMeterLiveBypassDuration response
func CreateDescribeMeterLiveBypassDurationResponse() (response *DescribeMeterLiveBypassDurationResponse) {
	response = &DescribeMeterLiveBypassDurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
