package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveMessageGroupBand invokes the live.AddLiveMessageGroupBand API synchronously
func (client *Client) AddLiveMessageGroupBand(request *AddLiveMessageGroupBandRequest) (response *AddLiveMessageGroupBandResponse, err error) {
	response = CreateAddLiveMessageGroupBandResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveMessageGroupBandWithChan invokes the live.AddLiveMessageGroupBand API asynchronously
func (client *Client) AddLiveMessageGroupBandWithChan(request *AddLiveMessageGroupBandRequest) (<-chan *AddLiveMessageGroupBandResponse, <-chan error) {
	responseChan := make(chan *AddLiveMessageGroupBandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveMessageGroupBand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveMessageGroupBandWithCallback invokes the live.AddLiveMessageGroupBand API asynchronously
func (client *Client) AddLiveMessageGroupBandWithCallback(request *AddLiveMessageGroupBandRequest, callback func(response *AddLiveMessageGroupBandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveMessageGroupBandResponse
		var err error
		defer close(result)
		response, err = client.AddLiveMessageGroupBand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveMessageGroupBandRequest is the request struct for api AddLiveMessageGroupBand
type AddLiveMessageGroupBandRequest struct {
	*requests.RpcRequest
	BannedUsers *[]string `position:"Query" name:"BannedUsers"  type:"Repeated"`
	GroupId     string    `position:"Query" name:"GroupId"`
	DataCenter  string    `position:"Query" name:"DataCenter"`
	AppId       string    `position:"Query" name:"AppId"`
}

// AddLiveMessageGroupBandResponse is the response struct for api AddLiveMessageGroupBand
type AddLiveMessageGroupBandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLiveMessageGroupBandRequest creates a request to invoke AddLiveMessageGroupBand API
func CreateAddLiveMessageGroupBandRequest() (request *AddLiveMessageGroupBandRequest) {
	request = &AddLiveMessageGroupBandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveMessageGroupBand", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveMessageGroupBandResponse creates a response to parse from AddLiveMessageGroupBand response
func CreateAddLiveMessageGroupBandResponse() (response *AddLiveMessageGroupBandResponse) {
	response = &AddLiveMessageGroupBandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
