package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceUserBatch invokes the linkvisual.QueryFaceUserBatch API synchronously
func (client *Client) QueryFaceUserBatch(request *QueryFaceUserBatchRequest) (response *QueryFaceUserBatchResponse, err error) {
	response = CreateQueryFaceUserBatchResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceUserBatchWithChan invokes the linkvisual.QueryFaceUserBatch API asynchronously
func (client *Client) QueryFaceUserBatchWithChan(request *QueryFaceUserBatchRequest) (<-chan *QueryFaceUserBatchResponse, <-chan error) {
	responseChan := make(chan *QueryFaceUserBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceUserBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceUserBatchWithCallback invokes the linkvisual.QueryFaceUserBatch API asynchronously
func (client *Client) QueryFaceUserBatchWithCallback(request *QueryFaceUserBatchRequest, callback func(response *QueryFaceUserBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceUserBatchResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceUserBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceUserBatchRequest is the request struct for api QueryFaceUserBatch
type QueryFaceUserBatchRequest struct {
	*requests.RpcRequest
	UserIdList  *[]string `position:"Query" name:"UserIdList"  type:"Repeated"`
	IsolationId string    `position:"Query" name:"IsolationId"`
	ApiProduct  string    `position:"Body" name:"ApiProduct"`
	ApiRevision string    `position:"Body" name:"ApiRevision"`
}

// QueryFaceUserBatchResponse is the response struct for api QueryFaceUserBatch
type QueryFaceUserBatchResponse struct {
	*responses.BaseResponse
	Code         string     `json:"Code" xml:"Code"`
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	ErrorMessage string     `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool       `json:"Success" xml:"Success"`
	Data         []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryFaceUserBatchRequest creates a request to invoke QueryFaceUserBatch API
func CreateQueryFaceUserBatchRequest() (request *QueryFaceUserBatchRequest) {
	request = &QueryFaceUserBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryFaceUserBatch", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceUserBatchResponse creates a response to parse from QueryFaceUserBatch response
func CreateQueryFaceUserBatchResponse() (response *QueryFaceUserBatchResponse) {
	response = &QueryFaceUserBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
