package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySpeechLicenseDeviceList invokes the iot.QuerySpeechLicenseDeviceList API synchronously
func (client *Client) QuerySpeechLicenseDeviceList(request *QuerySpeechLicenseDeviceListRequest) (response *QuerySpeechLicenseDeviceListResponse, err error) {
	response = CreateQuerySpeechLicenseDeviceListResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySpeechLicenseDeviceListWithChan invokes the iot.QuerySpeechLicenseDeviceList API asynchronously
func (client *Client) QuerySpeechLicenseDeviceListWithChan(request *QuerySpeechLicenseDeviceListRequest) (<-chan *QuerySpeechLicenseDeviceListResponse, <-chan error) {
	responseChan := make(chan *QuerySpeechLicenseDeviceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySpeechLicenseDeviceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySpeechLicenseDeviceListWithCallback invokes the iot.QuerySpeechLicenseDeviceList API asynchronously
func (client *Client) QuerySpeechLicenseDeviceListWithCallback(request *QuerySpeechLicenseDeviceListRequest, callback func(response *QuerySpeechLicenseDeviceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySpeechLicenseDeviceListResponse
		var err error
		defer close(result)
		response, err = client.QuerySpeechLicenseDeviceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySpeechLicenseDeviceListRequest is the request struct for api QuerySpeechLicenseDeviceList
type QuerySpeechLicenseDeviceListRequest struct {
	*requests.RpcRequest
	PageId            requests.Integer `position:"Query" name:"PageId"`
	LicenseStatusList *[]string        `position:"Body" name:"LicenseStatusList"  type:"Repeated"`
	IotInstanceId     string           `position:"Query" name:"IotInstanceId"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	ProductKey        string           `position:"Body" name:"ProductKey"`
	CheckGroupId      string           `position:"Body" name:"CheckGroupId"`
	ApiProduct        string           `position:"Body" name:"ApiProduct"`
	ApiRevision       string           `position:"Body" name:"ApiRevision"`
	DeviceName        string           `position:"Body" name:"DeviceName"`
}

// QuerySpeechLicenseDeviceListResponse is the response struct for api QuerySpeechLicenseDeviceList
type QuerySpeechLicenseDeviceListResponse struct {
	*responses.BaseResponse
	RequestId    string                             `json:"RequestId" xml:"RequestId"`
	Success      bool                               `json:"Success" xml:"Success"`
	Code         string                             `json:"Code" xml:"Code"`
	ErrorMessage string                             `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySpeechLicenseDeviceList `json:"Data" xml:"Data"`
}

// CreateQuerySpeechLicenseDeviceListRequest creates a request to invoke QuerySpeechLicenseDeviceList API
func CreateQuerySpeechLicenseDeviceListRequest() (request *QuerySpeechLicenseDeviceListRequest) {
	request = &QuerySpeechLicenseDeviceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySpeechLicenseDeviceList", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySpeechLicenseDeviceListResponse creates a response to parse from QuerySpeechLicenseDeviceList response
func CreateQuerySpeechLicenseDeviceListResponse() (response *QuerySpeechLicenseDeviceListResponse) {
	response = &QuerySpeechLicenseDeviceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
