package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAppSecret invokes the ims.DeleteAppSecret API synchronously
func (client *Client) DeleteAppSecret(request *DeleteAppSecretRequest) (response *DeleteAppSecretResponse, err error) {
	response = CreateDeleteAppSecretResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAppSecretWithChan invokes the ims.DeleteAppSecret API asynchronously
func (client *Client) DeleteAppSecretWithChan(request *DeleteAppSecretRequest) (<-chan *DeleteAppSecretResponse, <-chan error) {
	responseChan := make(chan *DeleteAppSecretResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAppSecret(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAppSecretWithCallback invokes the ims.DeleteAppSecret API asynchronously
func (client *Client) DeleteAppSecretWithCallback(request *DeleteAppSecretRequest, callback func(response *DeleteAppSecretResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAppSecretResponse
		var err error
		defer close(result)
		response, err = client.DeleteAppSecret(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAppSecretRequest is the request struct for api DeleteAppSecret
type DeleteAppSecretRequest struct {
	*requests.RpcRequest
	AkProxySuffix string `position:"Query" name:"AkProxySuffix"`
	AppSecretId   string `position:"Query" name:"AppSecretId"`
	AppId         string `position:"Query" name:"AppId"`
}

// DeleteAppSecretResponse is the response struct for api DeleteAppSecret
type DeleteAppSecretResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAppSecretRequest creates a request to invoke DeleteAppSecret API
func CreateDeleteAppSecretRequest() (request *DeleteAppSecretRequest) {
	request = &DeleteAppSecretRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "DeleteAppSecret", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAppSecretResponse creates a response to parse from DeleteAppSecret response
func CreateDeleteAppSecretResponse() (response *DeleteAppSecretResponse) {
	response = &DeleteAppSecretResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
