package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FeedbackSession invokes the imageprocess.FeedbackSession API synchronously
func (client *Client) FeedbackSession(request *FeedbackSessionRequest) (response *FeedbackSessionResponse, err error) {
	response = CreateFeedbackSessionResponse()
	err = client.DoAction(request, response)
	return
}

// FeedbackSessionWithChan invokes the imageprocess.FeedbackSession API asynchronously
func (client *Client) FeedbackSessionWithChan(request *FeedbackSessionRequest) (<-chan *FeedbackSessionResponse, <-chan error) {
	responseChan := make(chan *FeedbackSessionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FeedbackSession(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FeedbackSessionWithCallback invokes the imageprocess.FeedbackSession API asynchronously
func (client *Client) FeedbackSessionWithCallback(request *FeedbackSessionRequest, callback func(response *FeedbackSessionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FeedbackSessionResponse
		var err error
		defer close(result)
		response, err = client.FeedbackSession(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FeedbackSessionRequest is the request struct for api FeedbackSession
type FeedbackSessionRequest struct {
	*requests.RpcRequest
	SessionId string `position:"Body" name:"SessionId"`
	Feedback  string `position:"Body" name:"Feedback"`
}

// FeedbackSessionResponse is the response struct for api FeedbackSession
type FeedbackSessionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateFeedbackSessionRequest creates a request to invoke FeedbackSession API
func CreateFeedbackSessionRequest() (request *FeedbackSessionRequest) {
	request = &FeedbackSessionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "FeedbackSession", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateFeedbackSessionResponse creates a response to parse from FeedbackSession response
func CreateFeedbackSessionResponse() (response *FeedbackSessionResponse) {
	response = &FeedbackSessionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
