package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectChefCap invokes the facebody.DetectChefCap API synchronously
func (client *Client) DetectChefCap(request *DetectChefCapRequest) (response *DetectChefCapResponse, err error) {
	response = CreateDetectChefCapResponse()
	err = client.DoAction(request, response)
	return
}

// DetectChefCapWithChan invokes the facebody.DetectChefCap API asynchronously
func (client *Client) DetectChefCapWithChan(request *DetectChefCapRequest) (<-chan *DetectChefCapResponse, <-chan error) {
	responseChan := make(chan *DetectChefCapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectChefCap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectChefCapWithCallback invokes the facebody.DetectChefCap API asynchronously
func (client *Client) DetectChefCapWithCallback(request *DetectChefCapRequest, callback func(response *DetectChefCapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectChefCapResponse
		var err error
		defer close(result)
		response, err = client.DetectChefCap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectChefCapRequest is the request struct for api DetectChefCap
type DetectChefCapRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	OssFile            string           `position:"Query" name:"OssFile"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	ImageURL           string           `position:"Body" name:"ImageURL"`
}

// DetectChefCapResponse is the response struct for api DetectChefCap
type DetectChefCapResponse struct {
	*responses.BaseResponse
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Data      DataInDetectChefCap `json:"Data" xml:"Data"`
}

// CreateDetectChefCapRequest creates a request to invoke DetectChefCap API
func CreateDetectChefCapRequest() (request *DetectChefCapRequest) {
	request = &DetectChefCapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "DetectChefCap", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectChefCapResponse creates a response to parse from DetectChefCap response
func CreateDetectChefCapResponse() (response *DetectChefCapResponse) {
	response = &DetectChefCapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
