package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutTargets invokes the eventbridge.PutTargets API synchronously
func (client *Client) PutTargets(request *PutTargetsRequest) (response *PutTargetsResponse, err error) {
	response = CreatePutTargetsResponse()
	err = client.DoAction(request, response)
	return
}

// PutTargetsWithChan invokes the eventbridge.PutTargets API asynchronously
func (client *Client) PutTargetsWithChan(request *PutTargetsRequest) (<-chan *PutTargetsResponse, <-chan error) {
	responseChan := make(chan *PutTargetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutTargets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutTargetsWithCallback invokes the eventbridge.PutTargets API asynchronously
func (client *Client) PutTargetsWithCallback(request *PutTargetsRequest, callback func(response *PutTargetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutTargetsResponse
		var err error
		defer close(result)
		response, err = client.PutTargets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutTargetsRequest is the request struct for api PutTargets
type PutTargetsRequest struct {
	*requests.RpcRequest
	ClientToken  string               `position:"Query" name:"ClientToken"`
	RuleName     string               `position:"Query" name:"RuleName"`
	EventBusName string               `position:"Query" name:"EventBusName"`
	Targets      *[]PutTargetsTargets `position:"Query" name:"Targets"  type:"Json"`
}

// PutTargetsTargets is a repeated param struct in PutTargetsRequest
type PutTargetsTargets struct {
	Endpoint          string                            `name:"Endpoint"`
	PushRetryStrategy string                            `name:"PushRetryStrategy"`
	ParamList         *[]PutTargetsTargetsParamListItem `name:"ParamList" type:"Repeated"`
	Id                string                            `name:"Id"`
	DeadLetterQueue   PutTargetsTargetsDeadLetterQueue  `name:"DeadLetterQueue" type:"Struct"`
	Type              string                            `name:"Type"`
	ErrorsTolerance   string                            `name:"ErrorsTolerance"`
}

// PutTargetsTargetsParamListItem is a repeated param struct in PutTargetsRequest
type PutTargetsTargetsParamListItem struct {
	Template    string `name:"Template"`
	ResourceKey string `name:"ResourceKey"`
	Form        string `name:"Form"`
	Value       string `name:"Value"`
}

// PutTargetsTargetsDeadLetterQueue is a repeated param struct in PutTargetsRequest
type PutTargetsTargetsDeadLetterQueue struct {
	Arn string `name:"Arn"`
}

// PutTargetsResponse is the response struct for api PutTargets
type PutTargetsResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreatePutTargetsRequest creates a request to invoke PutTargets API
func CreatePutTargetsRequest() (request *PutTargetsRequest) {
	request = &PutTargetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "PutTargets", "", "")
	request.Method = requests.POST
	return
}

// CreatePutTargetsResponse creates a response to parse from PutTargets response
func CreatePutTargetsResponse() (response *PutTargetsResponse) {
	response = &PutTargetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
