package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveSDG invokes the ens.RemoveSDG API synchronously
func (client *Client) RemoveSDG(request *RemoveSDGRequest) (response *RemoveSDGResponse, err error) {
	response = CreateRemoveSDGResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveSDGWithChan invokes the ens.RemoveSDG API asynchronously
func (client *Client) RemoveSDGWithChan(request *RemoveSDGRequest) (<-chan *RemoveSDGResponse, <-chan error) {
	responseChan := make(chan *RemoveSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveSDGWithCallback invokes the ens.RemoveSDG API asynchronously
func (client *Client) RemoveSDGWithCallback(request *RemoveSDGRequest, callback func(response *RemoveSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveSDGResponse
		var err error
		defer close(result)
		response, err = client.RemoveSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveSDGRequest is the request struct for api RemoveSDG
type RemoveSDGRequest struct {
	*requests.RpcRequest
	InstanceIds *[]string `position:"Query" name:"InstanceIds"  type:"Json"`
}

// RemoveSDGResponse is the response struct for api RemoveSDG
type RemoveSDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveSDGRequest creates a request to invoke RemoveSDG API
func CreateRemoveSDGRequest() (request *RemoveSDGRequest) {
	request = &RemoveSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "RemoveSDG", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateRemoveSDGResponse creates a response to parse from RemoveSDG response
func CreateRemoveSDGResponse() (response *RemoveSDGResponse) {
	response = &RemoveSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
