package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseARMServerInstance invokes the ens.ReleaseARMServerInstance API synchronously
func (client *Client) ReleaseARMServerInstance(request *ReleaseARMServerInstanceRequest) (response *ReleaseARMServerInstanceResponse, err error) {
	response = CreateReleaseARMServerInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseARMServerInstanceWithChan invokes the ens.ReleaseARMServerInstance API asynchronously
func (client *Client) ReleaseARMServerInstanceWithChan(request *ReleaseARMServerInstanceRequest) (<-chan *ReleaseARMServerInstanceResponse, <-chan error) {
	responseChan := make(chan *ReleaseARMServerInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseARMServerInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseARMServerInstanceWithCallback invokes the ens.ReleaseARMServerInstance API asynchronously
func (client *Client) ReleaseARMServerInstanceWithCallback(request *ReleaseARMServerInstanceRequest, callback func(response *ReleaseARMServerInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseARMServerInstanceResponse
		var err error
		defer close(result)
		response, err = client.ReleaseARMServerInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseARMServerInstanceRequest is the request struct for api ReleaseARMServerInstance
type ReleaseARMServerInstanceRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ReleaseARMServerInstanceResponse is the response struct for api ReleaseARMServerInstance
type ReleaseARMServerInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReleaseARMServerInstanceRequest creates a request to invoke ReleaseARMServerInstance API
func CreateReleaseARMServerInstanceRequest() (request *ReleaseARMServerInstanceRequest) {
	request = &ReleaseARMServerInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ReleaseARMServerInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReleaseARMServerInstanceResponse creates a response to parse from ReleaseARMServerInstance response
func CreateReleaseARMServerInstanceResponse() (response *ReleaseARMServerInstanceResponse) {
	response = &ReleaseARMServerInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
