package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSecondaryPublicIpAddresses invokes the ens.DescribeSecondaryPublicIpAddresses API synchronously
func (client *Client) DescribeSecondaryPublicIpAddresses(request *DescribeSecondaryPublicIpAddressesRequest) (response *DescribeSecondaryPublicIpAddressesResponse, err error) {
	response = CreateDescribeSecondaryPublicIpAddressesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSecondaryPublicIpAddressesWithChan invokes the ens.DescribeSecondaryPublicIpAddresses API asynchronously
func (client *Client) DescribeSecondaryPublicIpAddressesWithChan(request *DescribeSecondaryPublicIpAddressesRequest) (<-chan *DescribeSecondaryPublicIpAddressesResponse, <-chan error) {
	responseChan := make(chan *DescribeSecondaryPublicIpAddressesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSecondaryPublicIpAddresses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSecondaryPublicIpAddressesWithCallback invokes the ens.DescribeSecondaryPublicIpAddresses API asynchronously
func (client *Client) DescribeSecondaryPublicIpAddressesWithCallback(request *DescribeSecondaryPublicIpAddressesRequest, callback func(response *DescribeSecondaryPublicIpAddressesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSecondaryPublicIpAddressesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSecondaryPublicIpAddresses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSecondaryPublicIpAddressesRequest is the request struct for api DescribeSecondaryPublicIpAddresses
type DescribeSecondaryPublicIpAddressesRequest struct {
	*requests.RpcRequest
	SecondaryPublicIpId      string           `position:"Query" name:"SecondaryPublicIpId"`
	Isp                      string           `position:"Query" name:"Isp"`
	PageNumber               requests.Integer `position:"Query" name:"PageNumber"`
	EnsRegionId              string           `position:"Query" name:"EnsRegionId"`
	PageSize                 requests.Integer `position:"Query" name:"PageSize"`
	SecondaryPublicIpAddress string           `position:"Query" name:"SecondaryPublicIpAddress"`
}

// DescribeSecondaryPublicIpAddressesResponse is the response struct for api DescribeSecondaryPublicIpAddresses
type DescribeSecondaryPublicIpAddressesResponse struct {
	*responses.BaseResponse
	RequestId                  string `json:"RequestId" xml:"RequestId"`
	PageNumber                 int    `json:"PageNumber" xml:"PageNumber"`
	PageSize                   int    `json:"PageSize" xml:"PageSize"`
	TotalCount                 int    `json:"TotalCount" xml:"TotalCount"`
	SecondaryPublicIpAddresses []Ip   `json:"SecondaryPublicIpAddresses" xml:"SecondaryPublicIpAddresses"`
}

// CreateDescribeSecondaryPublicIpAddressesRequest creates a request to invoke DescribeSecondaryPublicIpAddresses API
func CreateDescribeSecondaryPublicIpAddressesRequest() (request *DescribeSecondaryPublicIpAddressesRequest) {
	request = &DescribeSecondaryPublicIpAddressesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeSecondaryPublicIpAddresses", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSecondaryPublicIpAddressesResponse creates a response to parse from DescribeSecondaryPublicIpAddresses response
func CreateDescribeSecondaryPublicIpAddressesResponse() (response *DescribeSecondaryPublicIpAddressesResponse) {
	response = &DescribeSecondaryPublicIpAddressesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
