package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDynamicSettings invokes the elasticsearch.UpdateDynamicSettings API synchronously
func (client *Client) UpdateDynamicSettings(request *UpdateDynamicSettingsRequest) (response *UpdateDynamicSettingsResponse, err error) {
	response = CreateUpdateDynamicSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDynamicSettingsWithChan invokes the elasticsearch.UpdateDynamicSettings API asynchronously
func (client *Client) UpdateDynamicSettingsWithChan(request *UpdateDynamicSettingsRequest) (<-chan *UpdateDynamicSettingsResponse, <-chan error) {
	responseChan := make(chan *UpdateDynamicSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDynamicSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDynamicSettingsWithCallback invokes the elasticsearch.UpdateDynamicSettings API asynchronously
func (client *Client) UpdateDynamicSettingsWithCallback(request *UpdateDynamicSettingsRequest, callback func(response *UpdateDynamicSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDynamicSettingsResponse
		var err error
		defer close(result)
		response, err = client.UpdateDynamicSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDynamicSettingsRequest is the request struct for api UpdateDynamicSettings
type UpdateDynamicSettingsRequest struct {
	*requests.RoaRequest
	Mode        string `position:"Query" name:"mode"`
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Body        string `position:"Body" name:"body"`
}

// UpdateDynamicSettingsResponse is the response struct for api UpdateDynamicSettings
type UpdateDynamicSettingsResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDynamicSettingsRequest creates a request to invoke UpdateDynamicSettings API
func CreateUpdateDynamicSettingsRequest() (request *UpdateDynamicSettingsRequest) {
	request = &UpdateDynamicSettingsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateDynamicSettings", "/openapi/instances/[InstanceId]/dynamic-settings", "elasticsearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateDynamicSettingsResponse creates a response to parse from UpdateDynamicSettings response
func CreateUpdateDynamicSettingsResponse() (response *UpdateDynamicSettingsResponse) {
	response = &UpdateDynamicSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
