package eflo_controller

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFreeNodes invokes the eflo_controller.ListFreeNodes API synchronously
func (client *Client) ListFreeNodes(request *ListFreeNodesRequest) (response *ListFreeNodesResponse, err error) {
	response = CreateListFreeNodesResponse()
	err = client.DoAction(request, response)
	return
}

// ListFreeNodesWithChan invokes the eflo_controller.ListFreeNodes API asynchronously
func (client *Client) ListFreeNodesWithChan(request *ListFreeNodesRequest) (<-chan *ListFreeNodesResponse, <-chan error) {
	responseChan := make(chan *ListFreeNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFreeNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFreeNodesWithCallback invokes the eflo_controller.ListFreeNodes API asynchronously
func (client *Client) ListFreeNodesWithCallback(request *ListFreeNodesRequest, callback func(response *ListFreeNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFreeNodesResponse
		var err error
		defer close(result)
		response, err = client.ListFreeNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFreeNodesRequest is the request struct for api ListFreeNodes
type ListFreeNodesRequest struct {
	*requests.RpcRequest
	MachineType string           `position:"Body" name:"MachineType"`
	NextToken   string           `position:"Body" name:"NextToken"`
	MaxResults  requests.Integer `position:"Body" name:"MaxResults"`
}

// ListFreeNodesResponse is the response struct for api ListFreeNodes
type ListFreeNodesResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	NextToken string      `json:"NextToken" xml:"NextToken"`
	Nodes     []NodesItem `json:"Nodes" xml:"Nodes"`
}

// CreateListFreeNodesRequest creates a request to invoke ListFreeNodes API
func CreateListFreeNodesRequest() (request *ListFreeNodesRequest) {
	request = &ListFreeNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo-controller", "2022-12-15", "ListFreeNodes", "", "")
	request.Method = requests.POST
	return
}

// CreateListFreeNodesResponse creates a response to parse from ListFreeNodes response
func CreateListFreeNodesResponse() (response *ListFreeNodesResponse) {
	response = &ListFreeNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
