package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDiskDefaultKMSKeyId invokes the ecs.ModifyDiskDefaultKMSKeyId API synchronously
func (client *Client) ModifyDiskDefaultKMSKeyId(request *ModifyDiskDefaultKMSKeyIdRequest) (response *ModifyDiskDefaultKMSKeyIdResponse, err error) {
	response = CreateModifyDiskDefaultKMSKeyIdResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDiskDefaultKMSKeyIdWithChan invokes the ecs.ModifyDiskDefaultKMSKeyId API asynchronously
func (client *Client) ModifyDiskDefaultKMSKeyIdWithChan(request *ModifyDiskDefaultKMSKeyIdRequest) (<-chan *ModifyDiskDefaultKMSKeyIdResponse, <-chan error) {
	responseChan := make(chan *ModifyDiskDefaultKMSKeyIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDiskDefaultKMSKeyId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDiskDefaultKMSKeyIdWithCallback invokes the ecs.ModifyDiskDefaultKMSKeyId API asynchronously
func (client *Client) ModifyDiskDefaultKMSKeyIdWithCallback(request *ModifyDiskDefaultKMSKeyIdRequest, callback func(response *ModifyDiskDefaultKMSKeyIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDiskDefaultKMSKeyIdResponse
		var err error
		defer close(result)
		response, err = client.ModifyDiskDefaultKMSKeyId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDiskDefaultKMSKeyIdRequest is the request struct for api ModifyDiskDefaultKMSKeyId
type ModifyDiskDefaultKMSKeyIdRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	KMSKeyId        string           `position:"Query" name:"KMSKeyId"`
}

// ModifyDiskDefaultKMSKeyIdResponse is the response struct for api ModifyDiskDefaultKMSKeyId
type ModifyDiskDefaultKMSKeyIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDiskDefaultKMSKeyIdRequest creates a request to invoke ModifyDiskDefaultKMSKeyId API
func CreateModifyDiskDefaultKMSKeyIdRequest() (request *ModifyDiskDefaultKMSKeyIdRequest) {
	request = &ModifyDiskDefaultKMSKeyIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyDiskDefaultKMSKeyId", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDiskDefaultKMSKeyIdResponse creates a response to parse from ModifyDiskDefaultKMSKeyId response
func CreateModifyDiskDefaultKMSKeyIdResponse() (response *ModifyDiskDefaultKMSKeyIdResponse) {
	response = &ModifyDiskDefaultKMSKeyIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
