package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFlowStatistic invokes the ecd.DescribeFlowStatistic API synchronously
func (client *Client) DescribeFlowStatistic(request *DescribeFlowStatisticRequest) (response *DescribeFlowStatisticResponse, err error) {
	response = CreateDescribeFlowStatisticResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFlowStatisticWithChan invokes the ecd.DescribeFlowStatistic API asynchronously
func (client *Client) DescribeFlowStatisticWithChan(request *DescribeFlowStatisticRequest) (<-chan *DescribeFlowStatisticResponse, <-chan error) {
	responseChan := make(chan *DescribeFlowStatisticResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFlowStatistic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFlowStatisticWithCallback invokes the ecd.DescribeFlowStatistic API asynchronously
func (client *Client) DescribeFlowStatisticWithCallback(request *DescribeFlowStatisticRequest, callback func(response *DescribeFlowStatisticResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFlowStatisticResponse
		var err error
		defer close(result)
		response, err = client.DescribeFlowStatistic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFlowStatisticRequest is the request struct for api DescribeFlowStatistic
type DescribeFlowStatisticRequest struct {
	*requests.RpcRequest
	OfficeSiteId string           `position:"Query" name:"OfficeSiteId"`
	Period       requests.Integer `position:"Query" name:"Period"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	DesktopId    string           `position:"Query" name:"DesktopId"`
}

// DescribeFlowStatisticResponse is the response struct for api DescribeFlowStatistic
type DescribeFlowStatisticResponse struct {
	*responses.BaseResponse
	DesktopCount         int             `json:"DesktopCount" xml:"DesktopCount"`
	RequestId            string          `json:"RequestId" xml:"RequestId"`
	DesktopFlowStatistic []FlowStatistic `json:"DesktopFlowStatistic" xml:"DesktopFlowStatistic"`
}

// CreateDescribeFlowStatisticRequest creates a request to invoke DescribeFlowStatistic API
func CreateDescribeFlowStatisticRequest() (request *DescribeFlowStatisticRequest) {
	request = &DescribeFlowStatisticRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeFlowStatistic", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeFlowStatisticResponse creates a response to parse from DescribeFlowStatistic response
func CreateDescribeFlowStatisticResponse() (response *DescribeFlowStatisticResponse) {
	response = &DescribeFlowStatisticResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
