package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SmsConversionIntl invokes the dysmsapi.SmsConversionIntl API synchronously
func (client *Client) SmsConversionIntl(request *SmsConversionIntlRequest) (response *SmsConversionIntlResponse, err error) {
	response = CreateSmsConversionIntlResponse()
	err = client.DoAction(request, response)
	return
}

// SmsConversionIntlWithChan invokes the dysmsapi.SmsConversionIntl API asynchronously
func (client *Client) SmsConversionIntlWithChan(request *SmsConversionIntlRequest) (<-chan *SmsConversionIntlResponse, <-chan error) {
	responseChan := make(chan *SmsConversionIntlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SmsConversionIntl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SmsConversionIntlWithCallback invokes the dysmsapi.SmsConversionIntl API asynchronously
func (client *Client) SmsConversionIntlWithCallback(request *SmsConversionIntlRequest, callback func(response *SmsConversionIntlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SmsConversionIntlResponse
		var err error
		defer close(result)
		response, err = client.SmsConversionIntl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SmsConversionIntlRequest is the request struct for api SmsConversionIntl
type SmsConversionIntlRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	MessageId            string           `position:"Query" name:"MessageId"`
	Delivered            requests.Boolean `position:"Query" name:"Delivered"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ConversionTime       requests.Integer `position:"Query" name:"ConversionTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// SmsConversionIntlResponse is the response struct for api SmsConversionIntl
type SmsConversionIntlResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateSmsConversionIntlRequest creates a request to invoke SmsConversionIntl API
func CreateSmsConversionIntlRequest() (request *SmsConversionIntlRequest) {
	request = &SmsConversionIntlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "SmsConversionIntl", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSmsConversionIntlResponse creates a response to parse from SmsConversionIntl response
func CreateSmsConversionIntlResponse() (response *SmsConversionIntlResponse) {
	response = &SmsConversionIntlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
