package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDrdsInstanceVersion invokes the drds.DescribeDrdsInstanceVersion API synchronously
func (client *Client) DescribeDrdsInstanceVersion(request *DescribeDrdsInstanceVersionRequest) (response *DescribeDrdsInstanceVersionResponse, err error) {
	response = CreateDescribeDrdsInstanceVersionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDrdsInstanceVersionWithChan invokes the drds.DescribeDrdsInstanceVersion API asynchronously
func (client *Client) DescribeDrdsInstanceVersionWithChan(request *DescribeDrdsInstanceVersionRequest) (<-chan *DescribeDrdsInstanceVersionResponse, <-chan error) {
	responseChan := make(chan *DescribeDrdsInstanceVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDrdsInstanceVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDrdsInstanceVersionWithCallback invokes the drds.DescribeDrdsInstanceVersion API asynchronously
func (client *Client) DescribeDrdsInstanceVersionWithCallback(request *DescribeDrdsInstanceVersionRequest, callback func(response *DescribeDrdsInstanceVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDrdsInstanceVersionResponse
		var err error
		defer close(result)
		response, err = client.DescribeDrdsInstanceVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDrdsInstanceVersionRequest is the request struct for api DescribeDrdsInstanceVersion
type DescribeDrdsInstanceVersionRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// DescribeDrdsInstanceVersionResponse is the response struct for api DescribeDrdsInstanceVersion
type DescribeDrdsInstanceVersionResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeDrdsInstanceVersionRequest creates a request to invoke DescribeDrdsInstanceVersion API
func CreateDescribeDrdsInstanceVersionRequest() (request *DescribeDrdsInstanceVersionRequest) {
	request = &DescribeDrdsInstanceVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeDrdsInstanceVersion", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDrdsInstanceVersionResponse creates a response to parse from DescribeDrdsInstanceVersion response
func CreateDescribeDrdsInstanceVersionResponse() (response *DescribeDrdsInstanceVersionResponse) {
	response = &DescribeDrdsInstanceVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
