package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstanceUserPermissions invokes the dms_enterprise.ListInstanceUserPermissions API synchronously
func (client *Client) ListInstanceUserPermissions(request *ListInstanceUserPermissionsRequest) (response *ListInstanceUserPermissionsResponse, err error) {
	response = CreateListInstanceUserPermissionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceUserPermissionsWithChan invokes the dms_enterprise.ListInstanceUserPermissions API asynchronously
func (client *Client) ListInstanceUserPermissionsWithChan(request *ListInstanceUserPermissionsRequest) (<-chan *ListInstanceUserPermissionsResponse, <-chan error) {
	responseChan := make(chan *ListInstanceUserPermissionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstanceUserPermissions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceUserPermissionsWithCallback invokes the dms_enterprise.ListInstanceUserPermissions API asynchronously
func (client *Client) ListInstanceUserPermissionsWithCallback(request *ListInstanceUserPermissionsRequest, callback func(response *ListInstanceUserPermissionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceUserPermissionsResponse
		var err error
		defer close(result)
		response, err = client.ListInstanceUserPermissions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceUserPermissionsRequest is the request struct for api ListInstanceUserPermissions
type ListInstanceUserPermissionsRequest struct {
	*requests.RpcRequest
	Tid        requests.Integer `position:"Query" name:"Tid"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	UserName   string           `position:"Query" name:"UserName"`
}

// ListInstanceUserPermissionsResponse is the response struct for api ListInstanceUserPermissions
type ListInstanceUserPermissionsResponse struct {
	*responses.BaseResponse
	TotalCount      int64                                        `json:"TotalCount" xml:"TotalCount"`
	RequestId       string                                       `json:"RequestId" xml:"RequestId"`
	ErrorCode       string                                       `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage    string                                       `json:"ErrorMessage" xml:"ErrorMessage"`
	Success         bool                                         `json:"Success" xml:"Success"`
	UserPermissions UserPermissionsInListInstanceUserPermissions `json:"UserPermissions" xml:"UserPermissions"`
}

// CreateListInstanceUserPermissionsRequest creates a request to invoke ListInstanceUserPermissions API
func CreateListInstanceUserPermissionsRequest() (request *ListInstanceUserPermissionsRequest) {
	request = &ListInstanceUserPermissionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListInstanceUserPermissions", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListInstanceUserPermissionsResponse creates a response to parse from ListInstanceUserPermissions response
func CreateListInstanceUserPermissionsResponse() (response *ListInstanceUserPermissionsResponse) {
	response = &ListInstanceUserPermissionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
