package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAbacPolicy invokes the dms_enterprise.CreateAbacPolicy API synchronously
func (client *Client) CreateAbacPolicy(request *CreateAbacPolicyRequest) (response *CreateAbacPolicyResponse, err error) {
	response = CreateCreateAbacPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAbacPolicyWithChan invokes the dms_enterprise.CreateAbacPolicy API asynchronously
func (client *Client) CreateAbacPolicyWithChan(request *CreateAbacPolicyRequest) (<-chan *CreateAbacPolicyResponse, <-chan error) {
	responseChan := make(chan *CreateAbacPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAbacPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAbacPolicyWithCallback invokes the dms_enterprise.CreateAbacPolicy API asynchronously
func (client *Client) CreateAbacPolicyWithCallback(request *CreateAbacPolicyRequest, callback func(response *CreateAbacPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAbacPolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateAbacPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAbacPolicyRequest is the request struct for api CreateAbacPolicy
type CreateAbacPolicyRequest struct {
	*requests.RpcRequest
	AbacPolicyContent string           `position:"Query" name:"AbacPolicyContent"`
	Tid               requests.Integer `position:"Query" name:"Tid"`
	AbacPolicyDesc    string           `position:"Query" name:"AbacPolicyDesc"`
	AbacPolicyName    string           `position:"Query" name:"AbacPolicyName"`
}

// CreateAbacPolicyResponse is the response struct for api CreateAbacPolicy
type CreateAbacPolicyResponse struct {
	*responses.BaseResponse
	Success            bool   `json:"Success" xml:"Success"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	ErrorCode          string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage       string `json:"ErrorMessage" xml:"ErrorMessage"`
	CreatePolicyResult int64  `json:"CreatePolicyResult" xml:"CreatePolicyResult"`
}

// CreateCreateAbacPolicyRequest creates a request to invoke CreateAbacPolicy API
func CreateCreateAbacPolicyRequest() (request *CreateAbacPolicyRequest) {
	request = &CreateAbacPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateAbacPolicy", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAbacPolicyResponse creates a response to parse from CreateAbacPolicy response
func CreateCreateAbacPolicyResponse() (response *CreateAbacPolicyResponse) {
	response = &CreateAbacPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
