package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPortAutoCcStatus invokes the ddoscoo.ModifyPortAutoCcStatus API synchronously
func (client *Client) ModifyPortAutoCcStatus(request *ModifyPortAutoCcStatusRequest) (response *ModifyPortAutoCcStatusResponse, err error) {
	response = CreateModifyPortAutoCcStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPortAutoCcStatusWithChan invokes the ddoscoo.ModifyPortAutoCcStatus API asynchronously
func (client *Client) ModifyPortAutoCcStatusWithChan(request *ModifyPortAutoCcStatusRequest) (<-chan *ModifyPortAutoCcStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyPortAutoCcStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPortAutoCcStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPortAutoCcStatusWithCallback invokes the ddoscoo.ModifyPortAutoCcStatus API asynchronously
func (client *Client) ModifyPortAutoCcStatusWithCallback(request *ModifyPortAutoCcStatusRequest, callback func(response *ModifyPortAutoCcStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPortAutoCcStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyPortAutoCcStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPortAutoCcStatusRequest is the request struct for api ModifyPortAutoCcStatus
type ModifyPortAutoCcStatusRequest struct {
	*requests.RpcRequest
	Switch     string `position:"Query" name:"Switch"`
	Mode       string `position:"Query" name:"Mode"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
}

// ModifyPortAutoCcStatusResponse is the response struct for api ModifyPortAutoCcStatus
type ModifyPortAutoCcStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyPortAutoCcStatusRequest creates a request to invoke ModifyPortAutoCcStatus API
func CreateModifyPortAutoCcStatusRequest() (request *ModifyPortAutoCcStatusRequest) {
	request = &ModifyPortAutoCcStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyPortAutoCcStatus", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyPortAutoCcStatusResponse creates a response to parse from ModifyPortAutoCcStatus response
func CreateModifyPortAutoCcStatusResponse() (response *ModifyPortAutoCcStatusResponse) {
	response = &ModifyPortAutoCcStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
