package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachSceneDefenseObject invokes the ddoscoo.DetachSceneDefenseObject API synchronously
func (client *Client) DetachSceneDefenseObject(request *DetachSceneDefenseObjectRequest) (response *DetachSceneDefenseObjectResponse, err error) {
	response = CreateDetachSceneDefenseObjectResponse()
	err = client.DoAction(request, response)
	return
}

// DetachSceneDefenseObjectWithChan invokes the ddoscoo.DetachSceneDefenseObject API asynchronously
func (client *Client) DetachSceneDefenseObjectWithChan(request *DetachSceneDefenseObjectRequest) (<-chan *DetachSceneDefenseObjectResponse, <-chan error) {
	responseChan := make(chan *DetachSceneDefenseObjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachSceneDefenseObject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachSceneDefenseObjectWithCallback invokes the ddoscoo.DetachSceneDefenseObject API asynchronously
func (client *Client) DetachSceneDefenseObjectWithCallback(request *DetachSceneDefenseObjectRequest, callback func(response *DetachSceneDefenseObjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachSceneDefenseObjectResponse
		var err error
		defer close(result)
		response, err = client.DetachSceneDefenseObject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachSceneDefenseObjectRequest is the request struct for api DetachSceneDefenseObject
type DetachSceneDefenseObjectRequest struct {
	*requests.RpcRequest
	Objects    string `position:"Query" name:"Objects"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	PolicyId   string `position:"Query" name:"PolicyId"`
	ObjectType string `position:"Query" name:"ObjectType"`
}

// DetachSceneDefenseObjectResponse is the response struct for api DetachSceneDefenseObject
type DetachSceneDefenseObjectResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachSceneDefenseObjectRequest creates a request to invoke DetachSceneDefenseObject API
func CreateDetachSceneDefenseObjectRequest() (request *DetachSceneDefenseObjectRequest) {
	request = &DetachSceneDefenseObjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DetachSceneDefenseObject", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachSceneDefenseObjectResponse creates a response to parse from DetachSceneDefenseObject response
func CreateDetachSceneDefenseObjectResponse() (response *DetachSceneDefenseObjectResponse) {
	response = &DetachSceneDefenseObjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
