package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveDataServiceApiTestResult invokes the dataworks_public.SaveDataServiceApiTestResult API synchronously
func (client *Client) SaveDataServiceApiTestResult(request *SaveDataServiceApiTestResultRequest) (response *SaveDataServiceApiTestResultResponse, err error) {
	response = CreateSaveDataServiceApiTestResultResponse()
	err = client.DoAction(request, response)
	return
}

// SaveDataServiceApiTestResultWithChan invokes the dataworks_public.SaveDataServiceApiTestResult API asynchronously
func (client *Client) SaveDataServiceApiTestResultWithChan(request *SaveDataServiceApiTestResultRequest) (<-chan *SaveDataServiceApiTestResultResponse, <-chan error) {
	responseChan := make(chan *SaveDataServiceApiTestResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveDataServiceApiTestResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveDataServiceApiTestResultWithCallback invokes the dataworks_public.SaveDataServiceApiTestResult API asynchronously
func (client *Client) SaveDataServiceApiTestResultWithCallback(request *SaveDataServiceApiTestResultRequest, callback func(response *SaveDataServiceApiTestResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveDataServiceApiTestResultResponse
		var err error
		defer close(result)
		response, err = client.SaveDataServiceApiTestResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveDataServiceApiTestResultRequest is the request struct for api SaveDataServiceApiTestResult
type SaveDataServiceApiTestResultRequest struct {
	*requests.RpcRequest
	FailResultSample string           `position:"Body" name:"FailResultSample"`
	ResultSample     string           `position:"Body" name:"ResultSample"`
	AutoGenerate     requests.Boolean `position:"Body" name:"AutoGenerate"`
	ProjectId        requests.Integer `position:"Body" name:"ProjectId"`
	ApiId            requests.Integer `position:"Body" name:"ApiId"`
}

// SaveDataServiceApiTestResultResponse is the response struct for api SaveDataServiceApiTestResult
type SaveDataServiceApiTestResultResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           bool   `json:"Data" xml:"Data"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateSaveDataServiceApiTestResultRequest creates a request to invoke SaveDataServiceApiTestResult API
func CreateSaveDataServiceApiTestResultRequest() (request *SaveDataServiceApiTestResultRequest) {
	request = &SaveDataServiceApiTestResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "SaveDataServiceApiTestResult", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveDataServiceApiTestResultResponse creates a response to parse from SaveDataServiceApiTestResult response
func CreateSaveDataServiceApiTestResultResponse() (response *SaveDataServiceApiTestResultResponse) {
	response = &SaveDataServiceApiTestResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
