package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRecognizeRuleDetail invokes the dataworks_public.QueryRecognizeRuleDetail API synchronously
func (client *Client) QueryRecognizeRuleDetail(request *QueryRecognizeRuleDetailRequest) (response *QueryRecognizeRuleDetailResponse, err error) {
	response = CreateQueryRecognizeRuleDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRecognizeRuleDetailWithChan invokes the dataworks_public.QueryRecognizeRuleDetail API asynchronously
func (client *Client) QueryRecognizeRuleDetailWithChan(request *QueryRecognizeRuleDetailRequest) (<-chan *QueryRecognizeRuleDetailResponse, <-chan error) {
	responseChan := make(chan *QueryRecognizeRuleDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRecognizeRuleDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRecognizeRuleDetailWithCallback invokes the dataworks_public.QueryRecognizeRuleDetail API asynchronously
func (client *Client) QueryRecognizeRuleDetailWithCallback(request *QueryRecognizeRuleDetailRequest, callback func(response *QueryRecognizeRuleDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRecognizeRuleDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryRecognizeRuleDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRecognizeRuleDetailRequest is the request struct for api QueryRecognizeRuleDetail
type QueryRecognizeRuleDetailRequest struct {
	*requests.RpcRequest
	TenantId      string `position:"Body" name:"TenantId"`
	SensitiveName string `position:"Body" name:"SensitiveName"`
}

// QueryRecognizeRuleDetailResponse is the response struct for api QueryRecognizeRuleDetail
type QueryRecognizeRuleDetailResponse struct {
	*responses.BaseResponse
}

// CreateQueryRecognizeRuleDetailRequest creates a request to invoke QueryRecognizeRuleDetail API
func CreateQueryRecognizeRuleDetailRequest() (request *QueryRecognizeRuleDetailRequest) {
	request = &QueryRecognizeRuleDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "QueryRecognizeRuleDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryRecognizeRuleDetailResponse creates a response to parse from QueryRecognizeRuleDetail response
func CreateQueryRecognizeRuleDetailResponse() (response *QueryRecognizeRuleDetailResponse) {
	response = &QueryRecognizeRuleDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
