package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFullRequestSampleByInstanceId invokes the das.GetFullRequestSampleByInstanceId API synchronously
func (client *Client) GetFullRequestSampleByInstanceId(request *GetFullRequestSampleByInstanceIdRequest) (response *GetFullRequestSampleByInstanceIdResponse, err error) {
	response = CreateGetFullRequestSampleByInstanceIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetFullRequestSampleByInstanceIdWithChan invokes the das.GetFullRequestSampleByInstanceId API asynchronously
func (client *Client) GetFullRequestSampleByInstanceIdWithChan(request *GetFullRequestSampleByInstanceIdRequest) (<-chan *GetFullRequestSampleByInstanceIdResponse, <-chan error) {
	responseChan := make(chan *GetFullRequestSampleByInstanceIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFullRequestSampleByInstanceId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFullRequestSampleByInstanceIdWithCallback invokes the das.GetFullRequestSampleByInstanceId API asynchronously
func (client *Client) GetFullRequestSampleByInstanceIdWithCallback(request *GetFullRequestSampleByInstanceIdRequest, callback func(response *GetFullRequestSampleByInstanceIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFullRequestSampleByInstanceIdResponse
		var err error
		defer close(result)
		response, err = client.GetFullRequestSampleByInstanceId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFullRequestSampleByInstanceIdRequest is the request struct for api GetFullRequestSampleByInstanceId
type GetFullRequestSampleByInstanceIdRequest struct {
	*requests.RpcRequest
	Role       string           `position:"Query" name:"Role"`
	UserId     string           `position:"Body" name:"UserId"`
	InstanceId string           `position:"Body" name:"InstanceId"`
	SqlId      string           `position:"Body" name:"SqlId"`
	Start      requests.Integer `position:"Body" name:"Start"`
	End        requests.Integer `position:"Body" name:"End"`
}

// GetFullRequestSampleByInstanceIdResponse is the response struct for api GetFullRequestSampleByInstanceId
type GetFullRequestSampleByInstanceIdResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      []Item `json:"Data" xml:"Data"`
}

// CreateGetFullRequestSampleByInstanceIdRequest creates a request to invoke GetFullRequestSampleByInstanceId API
func CreateGetFullRequestSampleByInstanceIdRequest() (request *GetFullRequestSampleByInstanceIdRequest) {
	request = &GetFullRequestSampleByInstanceIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetFullRequestSampleByInstanceId", "", "")
	request.Method = requests.POST
	return
}

// CreateGetFullRequestSampleByInstanceIdResponse creates a response to parse from GetFullRequestSampleByInstanceId response
func CreateGetFullRequestSampleByInstanceIdResponse() (response *GetFullRequestSampleByInstanceIdResponse) {
	response = &GetFullRequestSampleByInstanceIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
