package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDefaultIPSConfig invokes the cloudfw.ModifyDefaultIPSConfig API synchronously
func (client *Client) ModifyDefaultIPSConfig(request *ModifyDefaultIPSConfigRequest) (response *ModifyDefaultIPSConfigResponse, err error) {
	response = CreateModifyDefaultIPSConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDefaultIPSConfigWithChan invokes the cloudfw.ModifyDefaultIPSConfig API asynchronously
func (client *Client) ModifyDefaultIPSConfigWithChan(request *ModifyDefaultIPSConfigRequest) (<-chan *ModifyDefaultIPSConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyDefaultIPSConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDefaultIPSConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDefaultIPSConfigWithCallback invokes the cloudfw.ModifyDefaultIPSConfig API asynchronously
func (client *Client) ModifyDefaultIPSConfigWithCallback(request *ModifyDefaultIPSConfigRequest, callback func(response *ModifyDefaultIPSConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDefaultIPSConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyDefaultIPSConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDefaultIPSConfigRequest is the request struct for api ModifyDefaultIPSConfig
type ModifyDefaultIPSConfigRequest struct {
	*requests.RpcRequest
	RunMode        string `position:"Query" name:"RunMode"`
	BasicRules     string `position:"Query" name:"BasicRules"`
	EnableDefault  string `position:"Query" name:"EnableDefault"`
	CtiRules       string `position:"Query" name:"CtiRules"`
	SourceIp       string `position:"Query" name:"SourceIp"`
	Lang           string `position:"Query" name:"Lang"`
	AiRules        string `position:"Query" name:"AiRules"`
	EnableAllPatch string `position:"Query" name:"EnableAllPatch"`
	PatchRules     string `position:"Query" name:"PatchRules"`
	RuleClass      string `position:"Query" name:"RuleClass"`
}

// ModifyDefaultIPSConfigResponse is the response struct for api ModifyDefaultIPSConfig
type ModifyDefaultIPSConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDefaultIPSConfigRequest creates a request to invoke ModifyDefaultIPSConfig API
func CreateModifyDefaultIPSConfigRequest() (request *ModifyDefaultIPSConfigRequest) {
	request = &ModifyDefaultIPSConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyDefaultIPSConfig", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDefaultIPSConfigResponse creates a response to parse from ModifyDefaultIPSConfig response
func CreateModifyDefaultIPSConfigResponse() (response *ModifyDefaultIPSConfigResponse) {
	response = &ModifyDefaultIPSConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
