package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTrFirewallsV2RouteList invokes the cloudfw.DescribeTrFirewallsV2RouteList API synchronously
func (client *Client) DescribeTrFirewallsV2RouteList(request *DescribeTrFirewallsV2RouteListRequest) (response *DescribeTrFirewallsV2RouteListResponse, err error) {
	response = CreateDescribeTrFirewallsV2RouteListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTrFirewallsV2RouteListWithChan invokes the cloudfw.DescribeTrFirewallsV2RouteList API asynchronously
func (client *Client) DescribeTrFirewallsV2RouteListWithChan(request *DescribeTrFirewallsV2RouteListRequest) (<-chan *DescribeTrFirewallsV2RouteListResponse, <-chan error) {
	responseChan := make(chan *DescribeTrFirewallsV2RouteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTrFirewallsV2RouteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTrFirewallsV2RouteListWithCallback invokes the cloudfw.DescribeTrFirewallsV2RouteList API asynchronously
func (client *Client) DescribeTrFirewallsV2RouteListWithCallback(request *DescribeTrFirewallsV2RouteListRequest, callback func(response *DescribeTrFirewallsV2RouteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTrFirewallsV2RouteListResponse
		var err error
		defer close(result)
		response, err = client.DescribeTrFirewallsV2RouteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTrFirewallsV2RouteListRequest is the request struct for api DescribeTrFirewallsV2RouteList
type DescribeTrFirewallsV2RouteListRequest struct {
	*requests.RpcRequest
	FirewallId              string `position:"Query" name:"FirewallId"`
	SourceIp                string `position:"Query" name:"SourceIp"`
	PageSize                string `position:"Query" name:"PageSize"`
	Lang                    string `position:"Query" name:"Lang"`
	CurrentPage             string `position:"Query" name:"CurrentPage"`
	TrFirewallRoutePolicyId string `position:"Query" name:"TrFirewallRoutePolicyId"`
}

// DescribeTrFirewallsV2RouteListResponse is the response struct for api DescribeTrFirewallsV2RouteList
type DescribeTrFirewallsV2RouteListResponse struct {
	*responses.BaseResponse
	RequestId               string                        `json:"RequestId" xml:"RequestId"`
	FirewallRouteDetailList []FirewallRouteDetailListItem `json:"FirewallRouteDetailList" xml:"FirewallRouteDetailList"`
}

// CreateDescribeTrFirewallsV2RouteListRequest creates a request to invoke DescribeTrFirewallsV2RouteList API
func CreateDescribeTrFirewallsV2RouteListRequest() (request *DescribeTrFirewallsV2RouteListRequest) {
	request = &DescribeTrFirewallsV2RouteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeTrFirewallsV2RouteList", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTrFirewallsV2RouteListResponse creates a response to parse from DescribeTrFirewallsV2RouteList response
func CreateDescribeTrFirewallsV2RouteListResponse() (response *DescribeTrFirewallsV2RouteListResponse) {
	response = &DescribeTrFirewallsV2RouteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
