package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddControlPolicy invokes the cloudfw.AddControlPolicy API synchronously
func (client *Client) AddControlPolicy(request *AddControlPolicyRequest) (response *AddControlPolicyResponse, err error) {
	response = CreateAddControlPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// AddControlPolicyWithChan invokes the cloudfw.AddControlPolicy API asynchronously
func (client *Client) AddControlPolicyWithChan(request *AddControlPolicyRequest) (<-chan *AddControlPolicyResponse, <-chan error) {
	responseChan := make(chan *AddControlPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddControlPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddControlPolicyWithCallback invokes the cloudfw.AddControlPolicy API asynchronously
func (client *Client) AddControlPolicyWithCallback(request *AddControlPolicyRequest, callback func(response *AddControlPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddControlPolicyResponse
		var err error
		defer close(result)
		response, err = client.AddControlPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddControlPolicyRequest is the request struct for api AddControlPolicy
type AddControlPolicyRequest struct {
	*requests.RpcRequest
	DestPortType        string    `position:"Query" name:"DestPortType"`
	MessageType         string    `position:"Query" name:"MessageType"`
	Release             string    `position:"Query" name:"Release"`
	Destination         string    `position:"Query" name:"Destination"`
	DestinationType     string    `position:"Query" name:"DestinationType"`
	DestPortGroup       string    `position:"Query" name:"DestPortGroup"`
	ApplicationNameList *[]string `position:"Query" name:"ApplicationNameList"  type:"Repeated"`
	Description         string    `position:"Query" name:"Description"`
	Source              string    `position:"Query" name:"Source"`
	AclAction           string    `position:"Query" name:"AclAction"`
	SourceIp            string    `position:"Query" name:"SourceIp"`
	NewOrder            string    `position:"Query" name:"NewOrder"`
	SourceType          string    `position:"Query" name:"SourceType"`
	IpVersion           string    `position:"Query" name:"IpVersion"`
	Lang                string    `position:"Query" name:"Lang"`
	Direction           string    `position:"Query" name:"Direction"`
	ApplicationName     string    `position:"Query" name:"ApplicationName"`
	Proto               string    `position:"Query" name:"Proto"`
	DestPort            string    `position:"Query" name:"DestPort"`
}

// AddControlPolicyResponse is the response struct for api AddControlPolicy
type AddControlPolicyResponse struct {
	*responses.BaseResponse
	AclUuid   string `json:"AclUuid" xml:"AclUuid"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddControlPolicyRequest creates a request to invoke AddControlPolicy API
func CreateAddControlPolicyRequest() (request *AddControlPolicyRequest) {
	request = &AddControlPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "AddControlPolicy", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddControlPolicyResponse creates a response to parse from AddControlPolicy response
func CreateAddControlPolicyResponse() (response *AddControlPolicyResponse) {
	response = &AddControlPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
