package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTemplateListByGroupId invokes the cloudesl.QueryTemplateListByGroupId API synchronously
func (client *Client) QueryTemplateListByGroupId(request *QueryTemplateListByGroupIdRequest) (response *QueryTemplateListByGroupIdResponse, err error) {
	response = CreateQueryTemplateListByGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTemplateListByGroupIdWithChan invokes the cloudesl.QueryTemplateListByGroupId API asynchronously
func (client *Client) QueryTemplateListByGroupIdWithChan(request *QueryTemplateListByGroupIdRequest) (<-chan *QueryTemplateListByGroupIdResponse, <-chan error) {
	responseChan := make(chan *QueryTemplateListByGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTemplateListByGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTemplateListByGroupIdWithCallback invokes the cloudesl.QueryTemplateListByGroupId API asynchronously
func (client *Client) QueryTemplateListByGroupIdWithCallback(request *QueryTemplateListByGroupIdRequest, callback func(response *QueryTemplateListByGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTemplateListByGroupIdResponse
		var err error
		defer close(result)
		response, err = client.QueryTemplateListByGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTemplateListByGroupIdRequest is the request struct for api QueryTemplateListByGroupId
type QueryTemplateListByGroupIdRequest struct {
	*requests.RpcRequest
	GroupId    string           `position:"Body" name:"GroupId"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// QueryTemplateListByGroupIdResponse is the response struct for api QueryTemplateListByGroupId
type QueryTemplateListByGroupIdResponse struct {
	*responses.BaseResponse
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string     `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool       `json:"Success" xml:"Success"`
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	Code           string     `json:"Code" xml:"Code"`
	Message        string     `json:"Message" xml:"Message"`
	DynamicMessage string     `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string     `json:"DynamicCode" xml:"DynamicCode"`
	TotalCount     int        `json:"TotalCount" xml:"TotalCount"`
	PageSize       int        `json:"PageSize" xml:"PageSize"`
	PageNumber     int        `json:"PageNumber" xml:"PageNumber"`
	TemplateList   []Template `json:"TemplateList" xml:"TemplateList"`
}

// CreateQueryTemplateListByGroupIdRequest creates a request to invoke QueryTemplateListByGroupId API
func CreateQueryTemplateListByGroupIdRequest() (request *QueryTemplateListByGroupIdRequest) {
	request = &QueryTemplateListByGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "QueryTemplateListByGroupId", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryTemplateListByGroupIdResponse creates a response to parse from QueryTemplateListByGroupId response
func CreateQueryTemplateListByGroupIdResponse() (response *QueryTemplateListByGroupIdResponse) {
	response = &QueryTemplateListByGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
